#include "utils/Timer.h"
#include "utils/network.h"
#include "transaction.h"
#include "ros.h"
#include "modset.h"
#include "or_set.h"

Timer cumm_ros_send_timer, cumm_mos_send_timer, cumm_nos_send_timer;

bool Transaction::encode(Network* net) const {
    //static bool printres = getenv("PRINT_TIME")? TRUE: FALSE;
    //Timer timer;

    bool res1 = tid.encode(net) && net->send_ubits32(coordinator, TRUE)
	&& participants->encode(net);

    cumm_ros_send_timer.start();
    //timer.reset(); timer.start();
    bool res2 = ros->encode(net);
    //timer.stop(); float ros_time = timer.elapsed();
    cumm_ros_send_timer.stop();

    cumm_mos_send_timer.start();
    //timer.reset(); timer.start();
    bool res3 = mos->encode(net);
    //timer.stop(); float mos_time = timer.elapsed();
    cumm_mos_send_timer.stop();

    cumm_nos_send_timer.start();
    //timer.reset(); timer.start();
    bool res4 = nos->encode(net);
    //timer.stop(); float nos_time = timer.elapsed();
    cumm_nos_send_timer.stop();

    //if (printres) {
    //fprintf(stderr, "Ros = %9.5f, Mos = %9.5f, Nos = %9.5f\n",
    //ros_time, mos_time, nos_time);
    //}

    return res1 && res2 && res3 && res4;
}

bool Transaction::decode(Network* net) {
    return (tid.decode(net) &&
            net->recv_ubits32(&coordinator) &&
	    participants->decode(net) &&
	    ros->decode(net) &&
	    mos->decode(net) &&
	    nos->decode(net));
}

void Transaction::print (bool whole_print, FILE *fp) {
    if (!fp) fp = stderr;
    fprintf(fp, "Tx: ");
    tid.print(fp);
    fprintf(fp, "Coordinator = %d\n Participants: ", coordinator);
    participants->print(fp);
    ros->print(fp);
    fprintf(fp, "MOS: Number = %d\n", mos->count());
    mos->print(whole_print, fp);
    fprintf(fp, "NOS: Number = %d\n", nos->count());
    nos->print(whole_print, fp);
}
