#ifndef _TRANSACTION_H
#define _TRANSACTION_H

/* This file contains the interface for transaction information transferred
   between the FE and the OR. A transaction object contains the ROS, MOS
   and the NOS.
*/

#include <stdio.h>
#include "tid.h"

class Modset;
class Ros;
class OR_set;
class Network;

class Transaction {
  public:
    Modset*  mos;
    Modset*  nos;
    Ros*  ros;
    Tid	  tid;
    Ubits32 coordinator;   // OR number of coordinator, or 0 if transaction
                           // is read-only everywhere.
    OR_set* participants;  // OR numbers of participants

    bool encode(Network*) const;
    bool decode(Network*);
    void print(bool whole_print, FILE *fp = NULL);
    // whole_print indicates if the objects in MOS/NOS have to be
    // printed totally
};

#endif /* _TRANSACTION_H */
