#include "utils/device.h"
#include "xrefs.h"

implementArray(Xrefs,Xref)

int encode_size(Xrefs const* xrefs) {
    return sizeof(Ubits32) + (sizeof(Xref) * xrefs->size());
}

bool encode_xrefs(Xrefs const *xrefs, Device *dev) {
    int num = xrefs->size();
    return (dev->send_ubits32(num, TRUE) &&
	    dev->send_buffer(xrefs->as_pointer(), (num*sizeof(Xref))));
}

bool decode_xrefs(Xrefs *xrefs, Device *dev) {
    Ubits32 count;
    if (!dev->recv_ubits32(&count)) return FALSE;

    xrefs->clear();
    xrefs->_enlarge_by(count);
    return (dev->recv_buffer(xrefs->as_pointer(), count*sizeof(Xref)));
}
