#include <stdio.h>

#include "compiler/C/obj.h"

#include "type_init.h"
#include "fe_wk_xref.h"

#include "config/vdefs/NDEBUG.h"

#include "utils/th_assert.h"

#define MAX_OREF 1000

bool Types_initted = FALSE;  

unsigned Last_oref = WK_LAST_OREF;

struct Class_s *Builtin_classes[MAX_OREF];
void Init_builtin_types()
{
    struct Builtin_obj const *bt = &Builtin_objs[0];

    int wk_index = 0;

    /* check the Orefs to make sure they're sequential. */
    while (bt->name) {
	wk_index++;
	assert(wk_index == (int)bt->oref);
	bt++;
    }

    Builtin_classes[0] = NULL;
    bt = &Builtin_objs[0];

    while (bt->name) {
	struct Class_s **o = bt->object;
	if (bt->init_func) {
            (*bt->init_func)();
	    (*o)->oref = bt->oref;
        }

	Builtin_classes[bt->oref] = *o;
	bt++;
    }
    Types_initted = TRUE;
    return;
}

void Bind_new_oref(struct Class_s *c) {
  int oref = Last_oref++;
  th_assert(oref < MAX_OREF, "too many orefs");
  c->oref  = oref;
  Builtin_classes[oref] = (struct Class_s *)c;
  return;
}
