#ifndef _TYPE_INIT_H
#define _TYPE_INIT_H

#include "compiler/C/dv.h"
#include "specs.h"

#ifdef __cplusplus
extern "C" {
#endif

extern unsigned  Last_oref;
extern struct Class_s *Builtin_classes[];

extern bool Types_initted;
/*
   This variable indicates whether it is okay to use runtime
   type discrimination features such as calling the "getClass"
   method. As the system is bootstrapping, it is FALSE, but
   is set to TRUE once all the builtin types are initialized.
*/

inline struct Class_s *Class_from_oref(Oref orx) { 
/*
    Return the class with this oref. Requires that "or" be a valid
    class oref.
*/
    struct Class_s *ret;
    th_assert(orx > 0 && orx < Last_oref, "Invalid class oref\n");
    ret = (struct Class_s *)Builtin_classes[orx];
    th_assert((Oref)ret->oref == orx, "class oref inconsistency");
    return ret;
}


void Init_builtin_types();
void Init_dirs();

void Bind_new_oref(struct Class_s *c);
/*
    Set c->oref to a new oref, and install the mapping oref => c into the
    table used by Class_from_oref.
*/

#ifdef __cplusplus
}
#endif

#endif /* _TYPE_INIT_H */
