#include "utils/mdebug.h"

#include "compiler/C++wrappers/core.h"

#include "resident_object_table.h"

Obj Resident_object_table::handle_to_obj(Handle h) {
  if (h < size && client_handle_table->test(h)) {
    // The handle is valid; return the object it refers to
    return fetch(h)->to_obj();
  }
  return 0;
}


Handle Resident_object_table::obj_to_handle(Obj o) {
  Core c = o->to_core();
  unsigned i = index(c);

  if (client_handle_table->test(i)) {
    // o already had a handle; return it
    return i;
  }

  // Allocate a handle for c
  client_handle_table->set(i);
  
  // Increment c's reference count to account for the handle
  inc_rc(c);

  return i;
}


unsigned Resident_object_table::free_handles(Handle *h, unsigned int sz) {
  unsigned no_valid = 0;
  for (unsigned int i=0; i < sz; i++) {
    Handle hand = h[i];
    bool valid_handle = hand < size && client_handle_table->test(hand);
    th_assert (valid_handle, "Invalid handle received in free handles");
    if (valid_handle) {
      no_valid++;
      client_handle_table->reset(hand);
      dec_rc(fetch(hand));
    }
  }
 
  // Indicate that handles were freed during the current transaction
  handles_freed = true;

  return no_valid;
}


//
// Handle generator methods.
//
  
Resident_object_table::
Handle_generator::Handle_generator(const Resident_object_table *r) : rot(r) {
  max_ind = rot->index(rot->free_area);

  // Make "cur_ind" point to the first entry with a handle.
  for (cur_ind = 0; cur_ind < max_ind; cur_ind++) {
    if (rot->client_handle_table->test(cur_ind))
      break;
  }
}
      
bool Resident_object_table::Handle_generator::get(Core &c) {
  if (cur_ind < max_ind) {
    c = rot->fetch(cur_ind);

    // Make "cur_ind" point to the next ROT entry with a handle
    for (++cur_ind; cur_ind < max_ind; cur_ind++) {
      if (rot->client_handle_table->test(cur_ind))
        break;
    }

    return true;
  } 
   
  return false;
}
