#include "runtime/stats.h"

#include "fe/main/fe_config.h"

#include "or_recv_data_msg.h"
#include "frame_info.h"
#include "persistent_cache.h"
#include "page_map.h"

OR_recv_data_msg::OR_recv_data_msg(){ rem_count = 0;}

bool OR_recv_data_msg::remove() const{
    return hdr.remainder.is_all_false();
}

int OR_recv_data_msg::setup_pages(Page **pages, iovec *iov,
					 Seg_bmap bmap) {
    int iov_count = 0;
    Uint dummy;
    Seg_bmap::Iter pages_iter(&bmap, TRUE);

    while (pages_iter.get(dummy)) {
	pages[iov_count] = FE->pc->alloc_page();
	FE->pc->lock_page(pages[iov_count]); // Unlocked by register pages.
	iov[iov_count].iov_base = (char *)pages[iov_count];
	iov[iov_count].iov_len = Page_size;
	iov_count++;
    }
    return iov_count;
}

bool OR_recv_data_msg::decode(Network *net, Ubits32 msg_id) {
    Persistent_cache *pc = FE->pc;
    bool success = FALSE;
    Page *pages[Max_pages_in_seg]; // Pages to be received in first message
    Page **recv_pages = &pages[0];

    if (!rem_count) {
	// First part of the message
	if (! net->recv_buffer(&hdr, sizeof(OR_recv_data_msg::header)))
	    return FALSE;
	th_assert(hdr.nobjects == 0, "cannot handle objects sent yet");
        th_assert((hdr.remainder & hdr.sent).is_all_false(),
		  "Page sent in first and second msg?");

	// Fill iovecs to read pages directly into the cache for first message
	iovec iov[Max_pages_in_seg];   
	int count = setup_pages(pages, iov, hdr.sent);

	// Fill iovecs to read pages directly into the cache for second message
	if (!hdr.remainder.is_all_false()) {
	    OR_info *or_info = FE->or_map->lookup(hdr.orid);
	    Seg_info * si = or_info->lookup_seg_info(hdr.segid);
	    th_assert(si, "Information about si is missing");

	    rem_count = setup_pages(rem_pages, rem_iov, hdr.remainder);
            th_assert(rem_count, "Remaining pages should not be zero");
	    // Set the number of objects on all these pages to be 0
	    // Add these pages to the pmap and in the OR_info data structure
	    // so that the fetch code can "find" them. Change is made to the
	    // pmap if the page did not exist in the cache (else a real merge
	    // needs to performed when the page is fetched)
	    Uint pnum;
	    Uint base_pageid = Pageid_from_segid(hdr.segid, 0);
	    pmap_remove.clear();
	    Seg_bmap::Iter pages_iter(&hdr.remainder, TRUE);
	    int i = 0;

	    while (pages_iter.get(pnum)) {
		th_assert(i < rem_count, "Setup pages is probably broken");
		rem_pages[i]->clear_page();
		Uint pindex = pc->index(rem_pages[i]);
		Frame_info *pinfo = pc->page_frame_info + pindex;
		pinfo->set_id(msg_id);
		pinfo->mark_evictable();
		if (!pc->pmap->lookup(hdr.orid, base_pageid + pnum)) {
		    pmap_remove.set(pnum);
		    rem_pages[i]->set_or(hdr.orid);
		    pc->pmap->store(base_pageid + pnum, pindex);
		    si->cached_pages.set(pnum);
		}
		i++;
	    }
	}

	// Read pages from network
	success = net->recv_vector(iov, count);
        FE_STATS(pc->net_fetch_time.stop())
   	FE_STATS(pc->tot_fore_pages += count);
    } else {
	// Get the second part of the message. Receive just the pages
	success = net->recv_vector(rem_iov, rem_count);
	recv_pages = &rem_pages[0];
	hdr.sent = hdr.remainder;
	FE_STATS(pc->num_delayed_fetches++);
	FE_STATS(pc->tot_back_pages += rem_count);
	hdr.remainder.clear();

	// Check if the page should be removed from the pmap before calling
	// register_pages
	OR_info *or_info = FE->or_map->lookup(hdr.orid);
	Seg_info * si = or_info->lookup_seg_info(hdr.segid);
	th_assert(si, "Information about si is missing");
	Seg_bmap::Iter pages_iter(&pmap_remove, TRUE);
	Uint base_pageid = Pageid_from_segid(hdr.segid, 0);
	Uint pnum;
	while (pages_iter.get(pnum)) {
	    pc->pmap->remove(hdr.orid, base_pageid + pnum);
	    si->cached_pages.reset(pnum);
	}
    }

    // If read was successful register fetched pages into PC and handle merges.
    th_assert(success, "Did not receive message correclty");
    pc->register_pages(hdr.orid, hdr.segid, hdr.sent, hdr.allocated,
		       hdr.empty, recv_pages);
    return TRUE;
}
