#ifndef _OR_RECV_DATA_MSG_H
#define _OR_RECV_DATA_MSG_H

// Handler for data (objects and pages) sent by the OR.

#include "utils/recv_message.h"
#include "common/oref.h"
#include "common/or_message.h"

union Page;

class OR_recv_data_msg: public Recv_message {
public:
    OR_recv_data_msg();
    // Create a new handler to recv data.

    Define_message_type(OR_data_type);
    Define_synch_msg();
    bool decode(Network *net, Ubits32 msg_id);
    bool remove() const;
  private:
    int setup_pages(Page **pages, iovec *iov, Seg_bmap bmap);
    // requires: pages is an array whose size is at least the no. of booleans
    //           that are true in bmap
    // effects: Sets up iov to contain pointers to (locked) pages allocated
    //          from the PC. Returns the number of pages allocate

    // struct to read in the header in one shot.
    // Must be kept in sync with the encode in OR_send_data_msg
    struct header {
	Ubits32 orid;
	Ubits32 segid;
	Ubits32 nobjects;
	Seg_bmap sent;
	Seg_bmap remainder; // Remainder of the pages that are expected to come
	Seg_bmap allocated;
	Seg_bmap empty;
    } hdr;

    Seg_bmap pmap_remove; // For egare prefetchin.These pages have to be
    // removed from the pmap when the real pages arrive

    iovec rem_iov[Max_pages_in_seg];    // Iovec for getting the remaining pages
    Page *rem_pages[Max_pages_in_seg];  // Remainder pages
    int rem_count; // Number of valid entries in rem_iov and rem_pages
};

#endif /* _OR_RECV_DATA_MSG_H */
