#include "fe/main/fe_config.h"
#include "persistent_cache.h"
#include "utils/th_assert.h"
#include "utils/hashfuncs.h"
#include "page_map.h"


Page_map::Page_map(unsigned size, Persistent_cache *pc) {
  size = size/6; // Average 6 mappings for bucket.

  // Round size to next power of 2
  unsigned mask = 1;
  unsigned bit_count = 0;
  while (mask < size) {
    mask = mask << 1;
    bit_count++;
  }
  num_buckets = mask;
  shift_bits = sizeof(unsigned)*8 - bit_count;
  table = new Page_map_entry[num_buckets];
  base = pc->page(0);
}


Page_map::~Page_map() { 
  for (unsigned i=0; i < num_buckets; i++) { 
    Page_map_entry *aux = table[i].next;
    while (aux) {
      Page_map_entry *tmp = aux;
      aux = aux->next;
      delete tmp;
    }
  }
  delete [] table; 
}


void Page_map::store(Uint page_id, Uint index) {
  th_assert(!lookup(base[index].get_or(), page_id), "Mapping for page exists in map");
  
  unsigned bucket_index = hash_unsigned(page_id) >> shift_bits;

  // First try to reuse any free mapping in the chain.
  Page_map_entry *tmp;
  for (tmp = table + bucket_index; tmp != 0; tmp = tmp->next) {
    for (int i=0; i < 3; i++) {
      if (tmp->mappings[i].is_free()) {
	tmp->mappings[i].page_id = page_id;
	tmp->mappings[i].page_index = index;
	return;
      }
    }
  }
  
  // No free mappings allocate a new entry and link it to the bucket.
  Page_map_entry *new_entry = new Page_map_entry;
  tmp = table + bucket_index;
  new_entry->next = tmp->next;
  tmp->next = new_entry;
  new_entry->mappings[0].page_id = page_id;
  new_entry->mappings[0].page_index = index;
}


void Page_map::remove(OR_num orx, Uint page_id) {
  th_assert(lookup(orx, page_id), "Mapping for page does not exist in map");

  unsigned bucket_index = hash_unsigned(page_id) >> shift_bits;
  Page_map_entry *cur;
  Page_map_entry *prev = 0;
  Page *found=0;

  for (cur = table + bucket_index; cur != 0; cur = cur->next) {
    for (int i=0; i < 3; i++) {
      found = cur->mappings[i].is_page(orx, page_id, base);
      if (found) {
	cur->mappings[i].mark_free();
        break;
      }
    }

    if (found) break;

    prev = cur;
  }
  
  // Deallocate entry if possible.
  if (prev && cur->mappings[0].is_free() && cur->mappings[1].is_free() 
      && cur->mappings[2].is_free()) {
    prev->next = cur->next;
    delete cur;
  }
}



