#include "scanned_set.h"
#include "utils/mdebug.h"
#include "utils/sort.h"

implementArray(Scanned_array, unsigned)


Scanned_set::Scanned_set(unsigned _nscans) {
  set = new Scanned_array[_nscans];
  min_usages = new int[_nscans];
  nscans = _nscans;
  current = 0;

  bins = new Scanned_array[Max_scanned_usage+1];
  num_bins = Max_scanned_usage+1;
  
  // Enlarge array allocation to a reasonable value to reduce the
  // cost of the first scans, and initialize min_usages.
  for (unsigned i=0; i < nscans; i++) {
    set[i].predict(128);
    min_usages[i] = Max_scanned_usage+1;
  }
}


Scanned_set::~Scanned_set() { 
  delete [] set; 
  delete [] bins;
  delete [] min_usages;
}


void Scanned_set::end_scan() {
  // A scan ended. Overwrite information from oldest scan in set.
  current = (current + 1) % nscans;
  set[current].clear();
    
  // Sort pages in scan by decreasing order of usage.
  for (int i=num_bins-1; i >= 0; i--) {
    while (bins[i].size() != 0) {
      set[current].append(make_index_usage_pair(bins[i].remove(), i));
    }
  }
  
  min_usages[current] =  
   (set[current].size()) ? get_usage(set[current].high()) : Max_scanned_usage+1;
}

