#ifndef Cplus_OBJ_H
#define Cplus_OBJ_H

#include "compiler/C/obj.h"
#include "compiler/C/dv.h"

#include "shortp.h"
#include "typedefs.h"

#include "common/obj_bitfield.h"

/* This is a generic object at the FE. Every object in the FE cache is an Obj.
   Code that does not need to know the types (e.g. ROT, client handles, etc)
   should use Obj. */

class Obj_c {

  /* Overview: Wrapper class for struct Obj_s defined in fe/compiler/C */

  public:
    inline Core to_core() const {return (Core) this;}
    /* Returns Core by adding proper offset. */
    /* Obsolete: Was useful when multiple dispatch vectors were supported */

    void set_dv(struct DV_hdr_s *m) {o.dv = FULL_AS_SHORTP(m);}
    /* Set the dv field to contain the DV m */

    inline struct Obj_DV * get_dv() const {
    /* Returns the dv field.*/
      return SHORTP_AS_FULL(struct Obj_DV, o.dv);
    }

    struct Class_s * get_class() const {
    /*  Returns a class object that describes this. */
      return get_dv()->hdr.self_class;
    }

private:
    Obj_s o;
};

DEFINE_shortp(Obj);

#endif /* Cplus_OBJ_H */
