#ifndef Cplus_SHORTP_H
#define Cplus_SHORTP_H

#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/th_assert.h"

#include "common/slot.h"
#include "common/shortp.h"


/* A "Shortp" is a slot-sized pointer used to reduce space usage, but it
   cannot be dereferenced directly. To
   dereference a short pointer, it must be first converted to a long
   pointer. It can also store bits of data (as many as the bits in a
   slot minus 1).

   A short pointer containing data generally contains an equivalent Oref.
   However, when the short pointer containing data is the fields pointer
   of an object, it contains the OR number instead.

   Conventions: shortp corresponding to pointer type "Tp" is named
   "Tp_x". A "Tp_x" holding a pointer can be created from a "Tp", 
   "Tp_x::pointer" returns a "Tp". A "Tp_x" holding data can be created 
   from a Ubits32, "Tp_x::data" returns the contained data. */


/* The following machine independent macro can be used to
   define a short pointer type for a long pointer type Tp */

#define DEFINE_shortp(Tp)						      \
class Tp##_x {								      \
public:									      \
    Tp##_x(void) {}							      \
    /* Creates an uninitialized short pointer */			      \
									      \
    Tp##_x(Tp tp) {x = FULL_AS_SHORTP(tp);}				      \
    /* Creates a short pointer holding a pointer */			      \
									      \
    void store_data(Ubits32 d) {x = DATA_TO_SHORTP(d);}			      \
    /* Creates a short pointer holding data. Only the bottom 31 bits	      \
       of data are preserved. */					      \
									      \
    bool is_data(void) const { return SHORTP_IS_DATA(x); }		      \
    /* Returns true iff short pointer holds data */			      \
									      \
    bool is_pointer(void) const { return !is_data(); }			      \
    /* Returns true iff short pointer holds a pointer */		      \
									      \
    Tp pointer() const {						      \
    /* Requires short pointer holds a pointer */			      \
      th_assert(!is_data(), "Called pointer on short pointer with data\n");   \
      return (Tp)SHORTP_AS_FULL_V(x);					      \
    }									      \
									      \
    Shortp data() const {						      \
    /* Requires the short pointer is holding a pointer */		      \
      th_assert(is_data(), "Called data on short pointer with pointer\n");    \
      return SHORTP_AS_DATA(Shortp, x);					      \
    }									      \
									      \
private:								      \
    Shortp x;								      \
}


typedef Slot *Slotp;
DEFINE_shortp(Slotp);

#endif /* Cplus_SHORTP_H */
