#ifndef _C_ARRAY_H
#define _C_ARRAY_H

#include "fields.h"
#include "dv.h"
#include "basic_types.h"

#include "common/slot.h"
#include "common/shortp.h"
#include "common/oref_basic.h"

#include "config/vdefs/SMALL_SLOTS.h"
#include "config/vdefs/PAGE_SIZE_BITS.h"
#include "config/vdefs/BASE_PAGE_SIZE_BITS.h"

/* Maximum number of slots in an array */
/* This should be computed */
#if SMALL_SLOTS
#define SLOTS (250 << (PAGE_SIZE_BITS-BASE_PAGE_SIZE_BITS))
#else
#define SLOTS (124 << (PAGE_SIZE_BITS-BASE_PAGE_SIZE_BITS))
/* 125 too high for SLOTS */
#endif

typedef struct Array_s {
  Shortp dv;
} *Array;

struct Array_f_s {
    struct Fields_s inh;
    Slot num_bytes;  /* The system initializes and uses this variable */
    UInt length;     /* Number of elements in the array */
};


#define DECLARE_Array(FT)                                                     \
                                                                              \
typedef struct FT##_Array_s {                                                 \
  Shortp dv;                                                                  \
} * FT##_Array;                                                              \
                                                                              \
struct FT##_Array_f_s {                                                       \
    struct Fields_s inh;                                                      \
    Slot num_bytes;  /* The system initializes and uses this variable */      \
    UInt length;     /* Number of elements in the array */                    \
    FT elems[1];     /* Actual length specified at initialization */          \
};

DECLARE_Array(Shortp)
DECLARE_Array(Boolean)
DECLARE_Array(Char)
DECLARE_Array(Byte)
DECLARE_Array(Short)
DECLARE_Array(Int)
DECLARE_Array(Long)
DECLARE_Array(Float)
DECLARE_Array(Double)

#endif /* _C_ARRAY_H */
