#ifndef _C_BASIC_TYPES_H
#define _C_BASIC_TYPES_H

#include "common/shortp.h"

/* Java types are capitalized. Sometimes they match C types. */

typedef void			Void;
typedef unsigned char		Boolean;
typedef unsigned short		Char;
typedef signed char		Byte;
typedef signed short		Short;
typedef signed int 		Int; 
typedef unsigned int		UInt;	/* only for >>>; not Java primitive */

/* dcurtis: added __i386__ as preprocessor seems broken */
#if ((0x40000000lu << 2) == 0) || __i386__	/* if long is just 32 bits wide */
    typedef signed long long	Long;
    typedef unsigned long long	ULong;	/* only for >>>; not Java primitive */
#else
#asdf
    typedef signed long		Long;
    typedef unsigned long	ULong;	/* only for >>>; not Java primitive */
#endif

typedef float			Float;
typedef double			Double;
typedef void *			Object;


#define Boolean_size sizeof(Boolean)
#define Char_size sizeof(Char)
#define Byte_size sizeof(Byte)
#define Short_size sizeof(Short)
#define Int_size sizeof(Int)
#define UInt_size sizeof(UInt)
#define Long_size sizeof(Long)
#define ULong_size sizeof(ULong)
#define Float_size sizeof(Float)
#define Double_size sizeof(Double)

#define Shorp_size sizeof(Shortp)


/* Java representations */

#define JAVA_FALSE	0
#define JAVA_TRUE	1
#define MIN_JAVA_INT ((Int) 0x80000000)
#define MAX_JAVA_INT ((Int) 0x7FFFFFFF)
#define MIN_JAVA_LONG ((Long)((ULong)1 << 63))
#define MAX_JAVA_LONG (~MIN_JAVA_LONG)

#define JAVA_NULL	((Object) 1)

#endif /* _C_BASIC_TYPES_H */
