#ifndef _C_FIELDS_H
#define _C_FIELDS_H

#include "common/slot.h"

/* "struct Fields_s" is contained at the beginning of every object
   fields structure. */

typedef struct Fields_s {
    Slot hus;                /* handle :24 | usage :4 | stamp :4 */
    /* Slot fields[N] */
} *Fields_p;

/* Masks to access the bits in the stamp */

#define READ_MASK 0x20
#define WRITTEN_MASK 0x10
#define POINTER_UPDATE_MASK 0x40
#define EAGER_REF_COUNTING_MASK 0x80
#define SET_USAGE_MASK 0x8
#define USAGE_MASK 0xf


#define IS_READ(F) (((Fields_p)(F))->hus & READ_MASK)
/*   bool IS_READ(Fields_p f);
     effects: Return whether read. */

#define IS_WRITTEN(F) (((Fields_p)(F))->hus & WRITTEN_MASK)
/*   bool IS_WRITTEN(Fields_p f);
     effects: Return whether written. */

#define MARK_PWRITTEN(F) (((Fields_p)(F))->hus |= POINTER_UPDATE_MASK)
/*   void MARK_PWRITTEN(Fields_p F);
     effects: Sets the pointer update bit in the fields of F
     (indicating that a pointer ivar of F was modified in the 
      current transaction). */

#define USE_EAGER_REF_COUNTING(F) (((Fields_p)(F))->hus & EAGER_REF_COUNTING_MASK)

#define MARK_EAGER_REF_COUNTING(F) (((Fields_p)(F))->hus |= EAGER_REF_COUNTING_MASK)

#define SET_USAGE(F) (((Fields_p)(F))->hus |= SET_USAGE_MASK)
/*    void SET_USAGE(Fields_p F);
      effects: Sets the usage bits of F to the maximum. */

#endif /* _C_FIELDS_H */

