#include <iostream.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#include "compiler/C/compiler.h"
#include "utils/map.h"
#include "boot/type_init.h"

#include "java_lang_Object.h"

extern struct java_lang_Object_bidirectional_DV The_java_lang_Object_DV;

typedef PtrMap<Class_s *, Class_s *> Imap;
#ifdef __GNUC__
template class PtrMap<Class_s *, Class_s *>;
#endif
#include "utils/impl_ptrmaps.t"

Imap array_instns;

struct Class_s *Instantiate_array(struct Class_s *T) {
    struct Class_s *ret;
    if (array_instns.find(T, ret)) return ret;

    ret = NEW_CLASS();
    Bind_new_oref(ret);
    // ret->name = "array";
    ret->flags = (IS_ARRAY | IS_PERSISTABLE);
    ret->elem_class = T;

    array_instns.add(T, ret); // must add before recursion

    CREATE_DV_I(ret, The_java_lang_Object_DV, 
		struct java_lang_Object_bidirectional_DV);

    ret->dv->num_slots = -1;
    ret->dv->bf = (T->flags & IS_PRIMITIVE) ? 0x80000000 : 0x85000000;
    // ZZZ: Should overload java.lang.Object's clone method also

    return ret;
}

static Array mkarray(struct Class_s *c,char type,int nDim,int nArgs, int *lengths) {
    int i;
    int length = lengths[0];

    if (nArgs > 1) {
      Shortp_Array A;
      ALLOC_ARRAY_RAW_G(A, Shortp, length, c);
      struct Shortp_Array_f_s *f = (struct Shortp_Array_f_s *) GET_FIELDS(A);
      PREPARE_PWRITE_F(f);
      for (i = 0; i < length; i++) {
	f->elems[i] = FULL_AS_SHORTP(mkarray(c->elem_class, type, nDim-1, nArgs-1, lengths+1));
      }
      return (Array) A;

    } else {
      switch (type) {
      case 'B': {
	Byte_Array A;
    	ALLOC_ARRAY_RAW_G(A, Byte, length, c);
	struct Byte_Array_f_s *f = (struct Byte_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'C': {
	Char_Array A;
	ALLOC_ARRAY_RAW_G(A, Char, length, c);
	struct Char_Array_f_s *f = (struct Char_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'D':  case 'd': {
	Double_Array A;
	ALLOC_ARRAY_RAW_G(A, Double, length, c);
	struct Double_Array_f_s *f = (struct Double_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'F':  case 'f': {
	Float_Array A;
	ALLOC_ARRAY_RAW_G(A, Float, length, c);
	struct Float_Array_f_s *f = (struct Float_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'I':  case 'i': {
	Int_Array A;
	ALLOC_ARRAY_RAW_G(A, Int, length, c);
	struct Int_Array_f_s *f = (struct Int_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'J':  case 'l': {
	Long_Array A;
	ALLOC_ARRAY_RAW_G(A, Long, length, c);
	struct Long_Array_f_s *f = (struct Long_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'S': {
	Short_Array A;
	ALLOC_ARRAY_RAW_G(A, Short, length, c);
	struct Short_Array_f_s *f = (struct Short_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      case 'Z': {
	Boolean_Array A;
	ALLOC_ARRAY_RAW_G(A, Boolean, length, c);
	struct Boolean_Array_f_s *f = (struct Boolean_Array_f_s *) GET_FIELDS(A);
	for(i=0; i<length; i++) {
	  f->elems[i] = 0;
	}
	return (Array) A;
      }
      default: {
	Shortp_Array A;
	ALLOC_ARRAY_RAW_G(A, Shortp, length, c);
	struct Shortp_Array_f_s *f = (struct Shortp_Array_f_s *) GET_FIELDS(A);
	PREPARE_PWRITE_F(f);
	for(i=0; i<length; i++) {
	  f->elems[i] = FULL_AS_SHORTP(JAVA_NULL);
	}
	return (Array) A;
      }
      }
    }
}

Array MNewArray(struct Class_s *c,char type,int nDim,int nArgs,/*l1,s1,l2,s2,*/...) {
    va_list ap;
    int i;
    int lengths[256];		/* bytecode limits dimensions to 256 max */

    /* store dimensions from vararg list in local array */
    va_start(ap, nArgs);
    for (i = 0; i < nArgs; i++) {
	lengths[i] = va_arg(ap, int);
    }
    va_end(ap);

    /* recursively create the requested number of dimensions */
    /* return mkarray(c, type, nArgs, nDim, lengths);  wrong arg order... */
    return mkarray(c, type, nDim, nArgs, lengths);
}
