/*  helpers.c -- native runtime helpers called from generated code  */

/*
 * Copyright 1996, 1997 Arizona Board of Regents; see COPYRIGHT file for
 * details.
 */

#include "toba.h"
#include "compiler/C/math.h"

#include <stdlib.h>
#include <math.h>


/*
 *  dtoi(d) -- convert double (or float) to int.
 */
Int dtoi(Double d)
{
    if (d != d)		/* if NaN */
    	return 0;
    else if (d >= MAX_JAVA_INT)
        return MAX_JAVA_INT;
    else if (d <= MIN_JAVA_INT)
        return MIN_JAVA_INT;
    else
    	return (Int)d;
}

/*
 *  dtol(d) -- convert double (or float) to long.
 */
Long dtol(Double d)
{
    if (d != d)		/* if NaN */
    	return 0;
    else if (d >= MAX_JAVA_LONG)
        return MAX_JAVA_LONG;
    else if (d <= MIN_JAVA_LONG)
        return MIN_JAVA_LONG;
    else
    	return (Long)d;
}

/*
 *  remdr(a,b) -- compute a % b.
 */
Double remdr(Double a, Double b)
{
    if (a != a || b != b || b == 0)
    	return 0.0 / 0.0;	/* NaN */
    else
    	return fmod(a, b);
}
