/*
 * sthreads_null.c
 *
 * Copyright 1996, 1997 Arizona Board of Regents; see COPYRIGHT file for
 * details.
 *
 * defines
 *    mythread
 *    sthread_init
 *    sthread_got_exception
 *    sthread_create
 *    sthread_stop
 *    sthread_yield
 *    sthread_sleep
 *    sthread_suspend
 *    sthread_resume
 *    sthread_setpriority
 *    sthread_current
 *    sthread_exit
 *    sthread_dontkill_start
 *    sthread_dontkill_end
 *    sthread_mutex_init
 *    sthread_mutex_lock
 *    sthread_mutex_unlock
 *    sthread_mutex_destroy
 *    sthread_cond_init
 *    sthread_cond_wait
 *    sthread_cond_signal
 *    sthread_cond_broadcast
 *    sthread_cond_destroy
 * 
 * TO DO:
 *   - There is some code in here that is not dependent
 *     on the underlying threads package - it should probably
 *     be broken out
 *
 * NOTE: We use the (otherwise unused) threadQ field of
 *       a java.lang.Thread to point to a thread's TCB
 */

#include <stdio.h>
#include <stddef.h>
#include <assert.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/time.h>

#include "compiler/C/compiler.h"
#include "compiler/sthreads.h"

static tcb *onlythread;

/*
 * Initialization of thread system
 */
void
sthread_init() 
{
    tcb *newtcb;

    /* create a java.lang.Thread object and a thread group
     * for this thread */
    newtcb = NEW(tcb);

    /* associate the TCB with this thread */
    onlythread = newtcb;

}

/*
 * Retrieve per-thread state
 */
tcb *
sthread_current()
{
    return onlythread;
}

struct mythread *
mythread()
{
    return &sthread_current()->mythread;
}

void
sthread_got_exception(void)
{
}
