/*  toba.h -- general definitions  */

/* 
 * Copyright 1996, 1997 Arizona Board of Regents; see COPYRIGHT file for 
 * details. 
 */


#ifndef _TOBA_H
#define _TOBA_H

#include <stdio.h>

#include "compiler/C/basic_types.h"
#include "compiler/sthreads.h"

#include "config/vdefs/NOTHREADS.h"

// typedef struct monitor *        Monitor;


/* structs for floating point constants */
/* union fconst { UInt b;  Float v;  }; */	/* float */ 
/* union dconst { ULong b; Double v; };	*/      /* double */



/* macro for yielding in non-preemptive threads */
#ifndef YIELD
#define YIELD ;
#endif

/* macros for control flow changes */
#define GOTO(oldpc,newlbl) goto newlbl
#define GOBACK(oldpc,newlbl) do { YIELD; goto newlbl; } while (0)
#define RETTO(oldpc,lblnum) do { tgt = lblnum; goto TOP; } while (0)



/* helper functions called by generated code */

/* start main program */
// int start(Class c, Void main(Object o), int argc, char *argv[]);

/* get current thread's per-thread structure */
/* struct mythread *mythread(); */


/* synchronization */
#ifdef NOTHREADS
#define monitorenter(o, t, v, r) ;
#define monitorexit(o, t, v, r) ;
#define enterclass(c, t, v, r) ;
#define exitclass(c, t, v, r) ;
#else
void monitorenter(Object o, struct mythread *thr, int val, volatile int *resp);
void monitorexit(Object o, struct mythread *thr, int val, volatile int *resp);
void enterclass(struct Class_s *c, struct mythread *thr, int val, volatile int *resp);
void exitclass(struct Class_s *c, struct mythread *thr, int val, volatile int *resp);
#endif


/* throw exception */
/* ZZZ: declared null funcs for now.  Also, other exceptions are removed */
#define throwDivisionByZeroException() {printf("Err1\n"); exit(1);}
#define throwNoSuchMethodError(o) {printf("Err2\n"); exit(1);}
#define throwNullPointerException(mesg) {printf("Err3\n"); exit(1);}
#define throwClassCastException(o) {printf("Err4\n"); exit(1);}

/* structs for floating point constants */
union fconst { UInt b;  Float v;  };	/* float */
union dconst { ULong b; Double v; };	/* double */

#endif /* _TOBA_H */
