/*
 * @(#)Class.java	1.55 97/07/08
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

package java.lang;
/*ZZZ
import java.lang.reflect.Member;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.io.InputStream;
*/

/**
 * Instances of the class </code>Class</code> represent classes and 
 * interfaces in a running Java application.
 * Every array also belongs to a class that is reflected as a Class
 * object that is shared by all arrays with the same element type and
 * number of dimensions.  Finally, the either primitive Java types
 * (boolean, byte, char, short, int, long, float, and double) and
 * the keyword void are also represented as Class objects.
 * <p>
 * There is no public constructor for the class </code>Class</code>. 
 * </code>Class</code> objects are constructed automatically by the Java 
 * Virtual Machine as classes are loaded and by calls to the 
 * <code>defineClass</code> method in the class loader. 
 * <p>
 * The following example uses a Class object to print the Class name
 * of an object:
 * <p><pre><blockquote>
 *     void printClassName(Object obj) {
 *         System.out.println("The class of " + obj +
 *                            " is " + obj.getClass().getName());
 *     }
 * </blockquote></pre>
 *
 * @author  unascribed
 * @version 1.55, 07/08/97
 * @see     java.lang.ClassLoader#defineClass(byte[], int, int)
 * @since   JDK1.0
 */
public final
class Class implements java.io.Serializable {
    /*
     * Constructor. Only the Java Virtual Machine creates Class
     * objects.
     */
    private Class() {}

}
