public class AtomicPart extends DesignObj {

  int id_, buildDate_, docId_, x_, y_;
  byte[] otype_;
  CompositePart super_;
  Connection[] from_, to_;
  int from_i, to_i;

  public AtomicPart() {
	otype_ = null;
	super_ = null;

	// OOO Constant
	from_ = null;
	from_i = 0;

	// OOO Constant
	to_ = null;
	to_i = 0;
  };

  public AtomicPart(int id, int buildDate, byte[] otype, int docId, int x,
		    int y, CompositePart _super) {

	id_ = id;
	buildDate_ = buildDate;
	otype_ = otype;
	docId_ = docId;
	x_ = x;
	y_ = y;
	super_ = _super;

	// OOO Constant
	from_ = new Connection[OO7_Creator.NumConnPerAtomic];
	from_i = 0;

	// OOO Constant
	to_ = new Connection[20];
	to_i = 0;
  }

  public int id() {
    return id_;
  }

  public int buildDate() {
    return buildDate_;
  }

  public void set_buildDate(int date) {
	buildDate_ = date;
  }

  public byte[] otype() {
  	return otype_;
  }

  public int docId() {
    return docId_;
  }

  public int x() {
    return x_;
  }

  public void set_x(int date) {
	x_ = date;
  }

  public int y() {
    return y_;
  }

  public void set_y(int date) {
	y_ = date;
  }

  public CompositePart superPart() {
	return super_;
  }

  public void add_outConnection(Connection con) {
	from_[from_i++] = con;
  }

  public void add_inConnection(Connection con) {
	to_[to_i++] = con;
  }

  public Connection outConnection(int i) {
	return from_[i];
  }

  public Connection inConnection(int i) {
	return to_[i];
  }

  public void doNothing() {
  }

  public void swapXY() {
	int tmp = x_;
	x_ = y_;
	y_ = tmp;
  }

  public int traverse(Traversal t) {
	int kind = t.kind();
	int result = 0;
	
	if (kind == 6)  
		return 1;

	intset visited = t.visited();
	if (visited.member(id_))
	  return 0;

	if (kind == 1) {
	  result = 1;
	  doNothing();
	} else if (kind == 21) {
	  if (visited.empty()) { // this is the first part
		result = 1;
		swapXY();
	  } 
	} else if (kind == 22) {
	  result = 1;
	  swapXY();
	}	else if (kind == 23) {
	  result = 4;
	  swapXY();
	  swapXY();
	  swapXY();
	  swapXY();
	} else if (kind == 3) {
	  // Ensure that we touch almost all the objects in
	  // a page to simulate almost perfect clustering.
	  result = otype_.length;
	  int i;
	  for (i=0; i<to_i; i++) {
		result += to_[i].otype().length;
	  } 
	} else if (kind > 100) {
	  result = 1;
	  doNothing();
	  visited.insert(id_);

	  if (visited.size() > kind - 100) {
		return -1;
	  }
	            
	  // traverse other atomic parts in reverse order
	  int ind = from_i-1;
	  while (ind >= 0) {
		AtomicPart next_ = from_[ind].to();
		int res =  next_.traverse(t);
		if (res < 0) {
		  ind = -1;
		} else {
		  result += res;
		}
		ind--;
	  }
	  return (result);
	}
	visited.insert(id_);



	// traverse other atomic parts
	int i;
	for (i=0; i<from_i; i++) {
	  AtomicPart next = from_[i].to();
	  result += next.traverse(t);
	}
	return (result);
  }

}
