// Calendar.java

public class Calendar {

  // This class represents a calendar. It stores Item objects which can
  // represent meetings, appointments, etc.

  // Items are stored in an array with maximum size MAX_ITEMS.
  public static int MAX_ITEMS = 20;

  // Each calendar should have a unique id
  int id, numItems;
  Item items[];

  // Constructor
  public Calendar(int id) {
    this.id = id;
    numItems = 0;
    items = new Item[MAX_ITEMS];
  }

  public int id() {
    return id;
  }

  public int numItems() {
    return numItems;
  }

  public Item getItem(int i) {
    if (i < numItems && i >=0) {
      return items[i];
    }
    else {
      return null;
    }
  }

  public void addItem(Item i) {
    if (numItems < MAX_ITEMS) {
      items[numItems++] = i;
    }
  }

  public void deleteItem(int i) {
    if (i < numItems && i >= 0) {
      items[i] = null;
      if (numItems != 1 && numItems-1 != i) {
	items[i] = items[numItems-1];
	items[numItems-1] = null;
      } 
      numItems--;
    }
  }

  public String toFile() {
    byte[] buffer = {  (byte)'C', (byte)'a', (byte)'l', (byte)'e', (byte)'n', (byte)'d', (byte)'a', (byte)'r', (byte)' ', (byte)'[', (byte)'v', (byte)'1', (byte)'.', (byte)'7', (byte)']', (byte)'\n' };
    buffer = Util.concat(buffer, write());
    return new String(buffer,0);
  }

  public byte[] write() {
    byte[] buffer = new byte[0];
    for (int i=0; i<numItems; i++) {
      buffer = Util.concat(buffer,items[i].write());
    }
    return buffer;
  }

}

