// CalendarDB.java

public class CalendarDB {

  public static int MAX_CALENDARS = 50;

  Calendar calendars[];
  String uids[];

  int numCalendars;

  public CalendarDB() {
    calendars = new Calendar[MAX_CALENDARS];
    uids = new String[MAX_CALENDARS];
    numCalendars = 0;
  }

  public int numCalendars() {
    return numCalendars;
  }

  public void addCalendar(Calendar c, String uid) {
    if (numCalendars < MAX_CALENDARS) {
      calendars[numCalendars] = c;
      uids[numCalendars++] = uid;
    }
  }

  public void deleteCalendar(int i) {
    if (i < numCalendars && i >= 0) {
      calendars[i] = null;
      uids[i] = null;
      if (numCalendars != 1 && numCalendars-1 != i) {
	calendars[i] = calendars[numCalendars-1];
	calendars[numCalendars-1] = null;
	uids[i] = uids[numCalendars-1];
	uids[numCalendars-1] = null;
      } 
      numCalendars--;
    }
  }

  public Calendar getCalendar(int i) {
    if (i < numCalendars && i >= 0) {
      return calendars[i];
    }
    return null;
  }

  public Calendar getCalendar(String uid) {
    for (int i=0; i<numCalendars; i++) {
      if (uids[i].equals(uid)) {
	return calendars[i];
      }
    }
    return null;
  }

  public String getUid(int i) {
    if (i < numCalendars && i >= 0) {
      return uids[i];
    }
    return null;
  }

  public boolean contains(String uid) {
    for (int i=0; i<numCalendars; i++) {
      if (uids[i].equals(uid)) {
	return true;
      }
    }
    return false;
  }
}
