// Date.java

public class Date {

  int day, year;
  Month month;

  public Date() {
    this.day = 0;
    this.year = 0;
    this.month = Month.January();
  }

  public Date(int day, Month month, int year) {
    this.day = day;
    this.month = month;
    this.year = year;
  }

/*
   Can't implement toString this way since System.arraycopy is not
   implemented (concatenating elements into a String uses StringBuffer
   which uses System.arraycopy)

  public String toString() {
    String s = month.name() + " " + day + " " + year;
    return s;
  }

*/

  public String toString() {

    byte space[] = { (byte)' ' };
    byte commaspace[] = { (byte)',', (byte)' '};

    int length = month.name().length();
    byte result[] = new byte[length];
    month.name().getBytes(0,length,result,0);

    byte d[] = Util.itostr(this.day,10);

    // concatenate month and day
    result = Util.concat(result,space);
    result = Util.concat(result,d);
    result = Util.concat(result,commaspace);

    byte y[] = Util.itostr(this.year,10);

    // concatenate 'month day, ' and year
    result = Util.concat(result,y);

    return new String(result,0);
  }

  public byte[] write() {
    byte slash[] = { (byte)'/' };

    byte[] buffer = new byte[0];

    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,Util.itostr(this.day,10)),slash),Util.itostr(this.month.rep,10)),slash),Util.itostr(this.year,10));
    return buffer;
  }

  public boolean equals(Date d) {
    if (d.year == this.year &&
	d.day  == this.day  &&
	this.month.equals(d.month))
      return true;
    else
      return false;
  }
}

/* 
   I needed to write my own int to str function since the one in
   Integer.java uses StringBuffer 
*/
