// Item.java

public abstract class Item {

  // This class is the base class for Items in a Calendar.
  // Every item must have
  // String name
  // String description
  // Date   start
  // Date   finish
	
  String name, description;
  Date start, finish;

  public Item(String name, String description) {
    this.name = name;
    this.description = description;
    this.start = new Date();
    this.finish = new Date();
  }

  public Item(String name, String description,
	      Date start, Date finish) {
    this.name = name;
    this.description = description;
    this.start = start;
    this.finish = finish;
  }

  public String name() {
    return name;
  }

  public String description() {
    return description;
  }

  public Date start() {
    return start;
  }

  public Date finish() {
    return finish;
  }

  public byte[] write() {
    byte textHeader[] = { (byte)'T', (byte)'e', (byte)'x', (byte)'t' };
    byte datesHeader[] = { (byte)'D', (byte)'a', (byte)'t', (byte)'e', (byte)'s' };
    byte singleHeader[] = { (byte)'S', (byte)'i', (byte)'n', (byte)'g', (byte)'l', (byte)'e' };
    byte endHeader[] = { (byte)'E', (byte)'n', (byte)'d' }; 

    byte space[] = { (byte)' ' };
    byte enter[] = { (byte)'\n' };
    byte openBracket[] = { (byte)'[' };
    byte endBracket[] = { (byte)']' };

    byte[] buffer = new byte[0];

    int len = this.description.length();
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,textHeader),space),openBracket),Util.itostr(len,10)),space),openBracket);
    byte tmp[] = new byte[len];
    this.description.getBytes(0,len,tmp,0);

    /* need to have multiple date representations - this class should have a date set rep */
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,tmp),endBracket),endBracket),enter),datesHeader),space),openBracket),singleHeader),space),start.write());

    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,space),endHeader),enter),endBracket),enter);

    return buffer;
  }

  public String toString() {
    byte onHeader[] = { (byte)'O', (byte)'n', (byte)' ', (byte)':', (byte)' ' };

    byte enter[] = { (byte)'\n' };
    byte dash[] = { (byte)'-' };
    byte space[] = { (byte)' ' };
    
    byte buffer[] = new byte[0];

    int len = this.name.length();
    byte tmp[] = new byte[len];
    this.name.getBytes(0,len,tmp,0);
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(buffer,tmp),space),dash),space);
    len = this.description.length();
    tmp = new byte[len];
    this.description.getBytes(0,len,tmp,0);
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,tmp),enter),onHeader),this.start.write()),enter);

    return new String(buffer,0);
  }

}


