// Notice.java

public class Notice extends Item {

  // This class represents a notice.
  // It is an item with a length (just for display)

  int length;

  public Notice(String name, String description,
		int length) {
    super(name,description);
    this.length = length;
  }

  public Notice(String name, String description,
		Date start, Date finish,
		int length) {
    super(name,description,start,finish);
    this.length = length;
  }

  public int length() {
    return length;
  }

  public byte[] write() {
    byte noteHeader[] = { (byte)'N', (byte)'o', (byte)'t', (byte)'e' };
    byte lengthHeader[] = { (byte)'L', (byte)'e', (byte)'n', (byte)'g', (byte)'t', (byte)'h' };
    
    byte space[] = { (byte)' ' };
    byte enter[] = { (byte)'\n' };
    byte openBracket[] = { (byte)'[' };
    byte endBracket[] = { (byte)']' };

    byte buffer[] = new byte[0];
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,noteHeader), space),openBracket),enter),lengthHeader),space), openBracket),Util.itostr(length,10)),endBracket),enter),super.write()),endBracket),enter);
    
    return buffer;
  }

  public String toString() {
    byte noticeHeader[] = { (byte)'N', (byte)'o', (byte)'t', (byte)'i', (byte)'c', (byte)'e' };
    byte lengthHeader[] = { (byte)'L', (byte)'e', (byte)'n', (byte)'g', (byte)'t', (byte)'h', (byte)':', (byte)' ' };
    
    byte enter[] = { (byte)'\n' };

    byte buffer[] = new byte[0];

    buffer = Util.concat(Util.concat(buffer,noticeHeader),enter);
    String superStr = super.toString();
    int len = superStr.length();
    byte tmp[] = new byte[len];
    superStr.getBytes(0,len,tmp,0);
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(buffer,tmp),lengthHeader),Util.itostr(length,10)),enter);

    return new String(buffer,0);
  }
}
