public class OO7DB {

  int numAtomicPerComp_, numConnPerAtomic_, documentSize_, manualSize_,
numCompPerModule_, numAssmPerAssm_, numAssmLevels_, numCompPerAssm_,
numModules_;

  OO7Module[] modules;
  int modules_i;  // size of modules

  public OO7DB(int numAtomicPerComp, int numConnPerAtomic, int documentSize,
int manualSize, int numCompPerModule, int numAssmPerAssm, int numAssmLevels,
int numCompPerAssm, int numModules) {

	numAtomicPerComp_ = numAtomicPerComp;
	numConnPerAtomic_ = numConnPerAtomic;
	documentSize_ = documentSize_;
	manualSize_ = manualSize_;
	numCompPerModule_ = numCompPerModule_;
	numAssmPerAssm_ = numAssmPerAssm_;
	numAssmLevels_ = numAssmLevels_;
	numCompPerAssm_ = numCompPerAssm_;
	numModules_ = numModules;

	// OOO: Constant
	modules = new OO7Module[numModules];
	modules_i = 0;
  }

  public void add_mod(OO7Module mod1) {
	modules[modules_i++] = mod1;
  }

  public OO7Module mod(int i) {
	return modules[i];
  }

  public int numAtomicPerComp() {
    return numAtomicPerComp_;
  }

  public int numConnPerAtomic() {
    return numConnPerAtomic_;
  }

  public int documentSize() {
    return documentSize_;
  }

  public int manualSize() {
    return manualSize_;
  }

  public int numCompPerModule() {
    return numCompPerModule_;
  }

  public int numAssmPerAssm() {
    return numAssmPerAssm_;
  }

  public int numAssmLevels() {
    return numAssmLevels_;
  }

  public int numCompPerAssm() {
    return numCompPerAssm_;
  }

  public int numModules() {
    return numModules_;
  }

  public int traverse(int kind) {
	Traversal t = new Traversal(kind, numAtomicPerComp_, 0, 0, 0);
	int result = 0;

	int i;
	for (i=0; i<modules_i; i++) {
	  result += modules[i].traverse(t);
	}
	
	return result;
  }

}
