public class OO7Module extends DesignObj {

  int id_;
  int buildDate_;
  byte[] otype_;
  Manual man_;
  Assembly root_;

  CompositePart[] composites;
  int composites_i;  // size of composites


  public OO7Module(int id, int buildDate, byte[] otype, Assembly root, Manual man) {

	// OOO Constant
	composites = new CompositePart[OO7_Creator.NumCompPerModule];
	composites_i = 0;

	id_ = id;
	buildDate_ = buildDate;
	otype_ = otype;
	root_ = root;
	man_ = man;
  }

  public int id() {
    return id_;
  }

  public int buildDate() {
    return buildDate_;
  }

  public void set_buildDate(int date) {
	buildDate_ = date;
  }

  public byte[] otype() {
  	return otype_;
  }

  public Manual man() {
    return man_;
  }

  public Assembly rootAssembly() {
    return root_;
  }
  
  public void add_composite(CompositePart c) {
	composites[composites_i++] = c;
  }

  public CompositePart fetch_composite(int i) {
    return composites[i];
  }

  public int traverse(Traversal t) {
	int result = root_.traverse(t);
	return result;
  }

  public int traverse_random(Traversal t) {
	int result = root_.traverse_random(t);
	return result;
  }

  public int traverse_random_path(Traversal t) {
	int result = root_.traverse_random_path(t);
	return result;
  }
}
