// Util.java

// a utility class for:
// - concatenating arrays
// - converting an integer to a String

public class Util {

  /* all possible chars for representing a number as a string */
  public static byte values[] = { (byte)'0', (byte)'1', (byte)'2', 
				  (byte)'3', (byte)'4', (byte)'5', 
				  (byte)'6', (byte)'7', (byte)'8', 
				  (byte)'9', (byte)'a', (byte)'b', 
				  (byte)'c', (byte)'d', (byte)'e', 
				  (byte)'f', (byte)'g', (byte)'h', 
				  (byte)'i', (byte)'j', (byte)'k', 
				  (byte)'l', (byte)'m', (byte)'n', 
				  (byte)'o', (byte)'p', (byte)'q', 
				  (byte)'r', (byte)'s', (byte)'t', 
				  (byte)'u', (byte)'v', (byte)'w', 
				  (byte)'x', (byte)'y', (byte)'z' };

  public static byte[] concat(byte[] a1, byte[] a2) {
    byte[] result = new byte[a1.length+a2.length];
    int a1length = a1.length;
    for (int i=0; i<a1length; i++) {
      result[i] = a1[i];
    }
    for (int i=0; i<a2.length; i++) {
      result[i+a1length] = a2[i];
    }
    return result;
  }

  public static byte[] itostr(int n, int radix) {

    if (radix < Character.MIN_RADIX || radix > Character.MAX_RADIX) {
      return null;
    }
    
    int i = n;
    
    if (i > 0) {
      n = -n;
    }

    /* 
       assuming int's are 4 bytes?? 
       maximum size of result will be 4 bytes * 8 = 32 byte array since
       base 2 will have 1 bit per array entry plus an extra entry for
       a negative sign
    */

    int maxsize = 33;
    byte result[] = new byte[maxsize];
    int pos = maxsize-1;
    for (; n <= -radix; n /= radix) {
      result[pos--] = values[-(n % radix)];
    }
    result[pos] = values[-n];
    
    if (i < 0) {
      result[--pos] = (byte)('-');
    }
    
    int size = maxsize-pos;
    byte shrink[] = new byte[size];
    for (int j=pos; j<maxsize; j++) {
      shrink[j-pos] = result[j];
    }
    
    return shrink;
  } 
}
