#include <stream.h>
#include <stdlib.h>

#include "utils/Timer.h"
#include "utils/Monitor.h"

#include "common/oref.h"

#include "compiler/sthreads.h"
#include "compiler/C/compiler.h"

#include "runtime/tm.h"
#include "runtime/stats.h"

#include "cache1/resident_object_table.h"
#include "cache1/persistent_cache.h"

#include "fe_config.h"

#include "config/vdefs/CHECK_UNSWIZ.h"

#include "java/thor/exports/java.h"
#include "java/source/exports/java.h"

static void create_and_insert (OO7_Creator creator, thor_Directory root) {
  // creates oo7 db and enters it in dir

  OO7DB db = (OO7DB) (DISPATCH_V_D((OO7_Creator) creator, DB__XJWw5, 
			   OO7_Creator))(creator);

  // Make sure db's entry in the ROT does not get discarded.
  FE->rot->obj_to_handle((Obj) db);

  // Check if we are overwriting a database
  OO7DB tmp_db = (OO7DB) (DISPATCH_V_D((thor_Directory) root, get_i_34DvE, 
				       thor_Directory))(root, 1001);  
  if (tmp_db != JAVA_NULL) 
      th_fail("Tried to overwrite an existing database");

  // Store the pointer to the db into thor_Directory
  (DISPATCH_V_D((thor_Directory) root, put_iO_EZlTS, 
		thor_Directory))(root, 1001, (java_lang_Object) db);

  if (FE->tm->commit())
      cout << "Committed all assemblies\n";
  else
      cout << "Failed in committing of assemblies\n"; 


  (DISPATCH_V_D((OO7_Creator) creator, Composites_O_N1WsR,
			   OO7_Creator))(creator, db);

  if (FE->tm->commit())
    cout << "Committed all composite parts\n";
  else
    cout << "Failed in creation of composite parts\n"; 

}

static int traversal_kind() {
  // Inputs the traversal kind and returns an integer encoding.
  int kind = 0;
  while (0 == kind) {
    cout << "Enter traversal kind (1, 2a, 2b, 2c, 3, 6): ";
    char kind_str[32];
    cin >> kind_str;
    if (!strcmp(kind_str, "1")) kind = 1;
    else if (!strcmp(kind_str, "2a")) kind = 21;
    else if (!strcmp(kind_str, "2b")) kind = 22;
    else if (!strcmp(kind_str, "2c")) kind = 23;
    else if (!strcmp(kind_str, "3")) kind = 3;
    else if (!strcmp(kind_str, "6")) kind = 6;
    else {
      int val = atoi(kind_str);
      if (val > 100 && val <= 300) kind = val;
    }
  }
  return kind;
}

bool traversal_cold() {
  // effects: Inputs the temperature of the traversal and returns FALSE
  //          if the traversal is "hot" (as for T1). Else returns TRUE
  
  bool cold = TRUE;
  cout << "Enter traversal temp (h/H for hot, any other char for cold): ";
  char cold_str[32];
  cin >> cold_str;
  if (cold_str[0] == 'H' || cold_str[0] == 'h') cold = FALSE;
  return cold;
}

void reset_stats(void) {
  // Reset execution statistics.
  FE->rot->reset_statistics();
  FE->pc->reset_statistics();
  FE->tm->reset_statistics();
  if (Get_or_stats(FE->initial_or_num, fe_stats->current)) {
    fe_stats->prev = fe_stats->current;
  } else {
    cout << "Failed to reset the statistics from the OR\n";
  }
}


void lookup_and_traverse (thor_Directory root) {
  // Traverses the oo7 db inserted in dir (under a prompted name).

  OO7DB db = (OO7DB) (DISPATCH_V_D((thor_Directory) root, get_i_34DvE, 
				   thor_Directory))(root, 1001);  
  if (db == JAVA_NULL) 
      th_fail("Database not yet created");

  int kind = traversal_kind();
  bool cold = traversal_cold();
  bool many = FALSE; 
  int repeat_count = 1;
  if (!cold) {
    cout << "Enter repeat count: ";
    cin >> repeat_count;
  }

  Timer t, c;
  int result = 0;
  int num_atomic =  DISPATCH_V_D(db, numAtomicPerComp__4LJik, OO7DB)(db);

  // Do not reset stats for hot small
  bool to_reset_stats = !(num_atomic == 20 && !cold);

  cout << "Traversal STARTED\n";
  for (int iternum = 0; iternum < repeat_count; iternum++) {
    if (to_reset_stats) reset_stats();
    t.reset();
    t.start();
    // resume_monitor();
    result =  DISPATCH_V_D(db, traverse_i_Ysmy5, OO7DB)(db, kind);
    // stop_monitor();
    t.stop();
    
    // Commit the transaction if we are running in "many' mode or
    // this is the last iteration
    if (iternum == repeat_count - 1 || many) {
      c.reset();
      c.start();
      if (!FE->tm->commit()) th_fail("Transaction aborted\n");
      c.stop();	
    }
  }

  cout << ((num_atomic == 200) ? "Medium" : "Small") << " traversal\n";

  cout << "Time for traversal = " << t.elapsed() << endl;
  cout << "Time for commit = " << c.elapsed() << endl;
  cout << "Total time = " << t.elapsed()+c.elapsed() << endl;
  cout << "Result from traversal = " << result << endl;
  cout << "Traversal DONE" << endl;
}


void java_main(thor_Directory root) {

  OO7_Creator creator;
  {
    struct OO7_Creator_P_s *self_P = OO7_Creator_P;
    ALLOC_OBJ(creator, OO7_Creator);
    cout << "Created OO7_Creator\n";
  }
  FE->rot->obj_to_handle((Obj) creator);

  (DISPATCH_N_D((OO7_Creator) creator, init__h2Mf2_, OO7_Creator))(creator);  
  cout << "Inited OO7_Creator\n";

  char com;
  do {
    
    cout << endl
	 << "s - create small oo7\n"
	 << "m - create medium oo7\n"
	 << endl
	 << "T/t - traverse oo7 within Thor\n"
	 << endl
	 << "D - Get statistics from the FE\n" 
	 << endl
	 << "q - quit\n"
	 << endl
	 << "Enter command: ";
    
    cin >> com;
    cout << endl;
    
    switch (com) {
      
    case 's': //create small oo7
      create_and_insert(creator, root);
      break;
      
    case 'm': // create medium oo7
      (DISPATCH_V_D((OO7_Creator) creator, set_medium__FDsNA, OO7_Creator))(creator);
      create_and_insert(creator, root);
      break;
      
    case 't':
    case 'T': // lookup and traverse oo7 within Thor
      lookup_and_traverse(root);
      break;
      
    case 'D': // Print FE statistics
      // Note: This is for internal use only. This is not suppose
      // to be used by clients in general

      cout << "Statistics STARTED\n";
      FE->rot->print_stats(cout);
      FE->pc->print_stats(cout);
      FE->tm->print_stats(stdout);
      if (Get_or_stats(FE->initial_or_num, fe_stats->current)) {
	cout << "\nOR statistics:\n";
	sub_stats(fe_stats->current, fe_stats->prev);
	report_stats(stdout, fe_stats->current);
	// fe_stats->prev = fe_stats->current;
      } else {
	cout << "Failed to get the statistics from the OR\n";
      }
      cout << "Statistics DONE\n";
      break;
      
    }
  } while (com != 'q');
  
  cout << "Exiting\n";
}
