#include "fe_send_message.h"
#include "invalidation.h"
#include "tm.h"

#include "cache1/resident_object_table.h"

#include "fe/main/fe_config.h"

#include "common/or_num.h"
#include "common/locator.h"

#include "utils/basic.h"
#include "utils/th_assert.h"
#include "utils/communication.h"

#define DEBUG_INVALIDATION FALSE

// This file handles the invalidation messages recevied by a frontend
// The TM methods have also been put here for the sake of separating
// out the invalidation code.

bool TM::invalidate_objects(OR_num orx, const Oref* inv_orefs,
			    int setsize, Ubits32 msg_start,
			    Ubits32 msg_end, Msg_Wait_Type wait_type) {

    // The fetched object may be invalidated. The cache fetch code should
    // check that this object is really present after the call returns.
    // Otherwise, it should send another fetch request

    OR_info *info = FE->or_map->lookup(orx);

    if (info->last_invalidation != msg_start - 1 || msg_end < msg_start || setsize <= 0)
        th_fail("Bad invalidation message received");
    info->last_invalidation = msg_end;

    // Invalidate the objects in inv_orefs. If they have been used in this
    // transaction, this transaction needs to be aborted.

    bool to_abort = FALSE; // New variable just to help in debugging
    for (int i = 0; i < setsize; i++) {
	bool used = FE->rot->invalidate_object(orx, inv_orefs[i]);
	to_abort = to_abort || used;
    }

    abort_transaction = abort_transaction || to_abort;
    if (FE->debug_level > 0)
	fprintf (stderr, "Invalidation: Type = %d, Aborted = %d\n",
		 wait_type, abort_transaction);

    // Send the invalidation acknowledgement. Note that it is not flushed
    th_assert (info->last_invalidation == info->last_inv_acked + 1,
	       "Bad invalidation number or ack number");
    info->last_inv_acked = info->last_invalidation;
    FE_send_invalid_ack_msg ack_msg(info->last_invalidation);
    Ubits32 req_id;
    if (!FE->comm->send(OR_address(orx), &ack_msg, NULL, req_id))
	perror("Error while sending invalid ack");

    return abort_transaction;
}
