#ifndef _OR_RECV_MESSAGE_H
#define _OR_RECV_MESSAGE_H

#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/recv_message.h"
#include "common/oref.h"
#include "common/orefs.h"
#include "common/or_message.h"

class Network;

// This file has all the messages that are received from the OR AND require
// OR-sepcific or FE-specific data strutures to be used. The other messages
// sent by the or/fe are in common/or_message.h common/fe_message.h


class OR_recv_root_msg: public Recv_message {
    // Overview: Reply to a get_root message
  public:
    Ubits32 type() const {return OR_root_type;}
    bool synchronous() const {return TRUE;}
    bool decode(Network* net, Ubits32) {
	// Stores root in or_root;
	return net->recv_ubits32(&or_root);
    }
    Oref or_root;
};

class OR_recv_commit_reply_msg:  public Recv_message {
    // Overview: Receive reply to a commit message 
  public:
    Define_message_type(OR_commit_reply_type);
    Define_synch_msg();
    bool decode(Network *net, Ubits32 msg_id);
    bool skip(Network *net);

    bool    commit;       // If the commit succeeded or not
    int     num_expected; // Number of replies expected
    int     num_received; // Number of replies received till now
};

class OR_recv_invalidation_msg: public Recv_message {
    // Overview: Invalidation message sent to the FE (asynchronous) 
  public:
    OR_recv_invalidation_msg() : msg_start(0), msg_end(0) {}
    Define_message_type(OR_invalidation_type);
    Define_asynch_msg();
    bool decode(Network *net, Ubits32 msg_id);
    bool skip(Network *net);

  private:
    Orefs       orefs;      // Invalid objects
    Ubits32     msg_start;   // Invalidation message numbers for start and end
    Ubits32     msg_end; 
};

class OR_recv_alloc_reply_msg:  public Recv_message {
    // Overview: For receiving allocation rights from the OR
  public:
    Define_message_type(OR_alloc_reply_type);
    Define_synch_msg();
    bool decode(Network *net, Ubits32 msg_id);
    bool skip(Network *net);

    Ubits32     segid;      // Segment id where rights are being granted
  private:
    Seg_bmap    bmap;       // Bitmap for segid to indicate which pages
                            // the FE is being allocation rights
    Seg_bmap    empty_bmap; // Pages that are empty and need not be fetched by
                            // FE for allocating new objects on the page
};
class OR_recv_debug_reply_msg:  public Recv_message {
    // Overview: For receiving debug replies from the OR
  public:
    Define_message_type(OR_debug_reply_type);
    Define_synch_msg();
    bool decode(Network*, Ubits32) { return TRUE;}
    bool skip(Network*, Ubits32)   { return TRUE;}
  private:
};

#endif /* _OR_RECV_MESSAGE_H */
