#ifndef _FE_STATS_H
#define _FE_STATS_H

#include "utils/basic.h"

#include "common/or_num.h"
#include "common/or_stat.h"

#include "config/vdefs/COLLECT_STATS.h"

/* 
     Put code to increment stats counters inside a call to FE_STATS.
     Then it goes away if COLLECT_STATS is FALSE.
*/

#if COLLECT_STATS
#define FE_STATS(x) (x);
#define FE_STATS_EXPR(x) (x)
#else
#define FE_STATS(x)
#define FE_STATS_EXPR(x) 0
#endif

struct FE_stats {
    OR_stat prev;    // The OR statistics that were gathered last
    OR_stat current; // The current stats
};

extern bool Get_or_stats(OR_num or_num, OR_stat& stat);
extern FE_stats *fe_stats; 

#endif /* _FE_STATS_H */


