//  ExternsFile.java -- methods for writing .pth files

package toba;

import java.io.*;
import java.util.*;

class ExternsFile {

static private Hashtable declared;	// set of class structs declared

static private Hashtable ivtable;	// table of visible instance variables
static private int hvnum;		// hidden variable number

static private boolean first_var = true;


//  write(d, c) -- write header info for class c on stream d.

static void write(PrintWriter d, ClassData c)
{

    // header file protection
    d.println();
    d.println("#ifndef " + c.cname + "_EXTERNS_H");
    d.println("#define " + c.cname + "_EXTERNS_H");

    d.println();
    d.println("#ifdef __cplusplus");
    d.println("extern \"C\" {");
    d.println("#endif");

    d.println("extern void Init_" + c.cname + "();");

    d.println();
    d.println("#ifdef __cplusplus");
    d.println("}");
    d.println("#endif");

    d.println();
    d.println("extern struct Class_s *" + c.cname + "_V;");
    d.println("extern struct Class_s *" + c.cname + "_static" + "_V;");


    // tail
    d.println();
    d.println("#endif /* " + c.cname + "_EXTERNS_H */");
}

} // class ExternsFile
