//  Field.java -- Methods and Variables

//  Copyright 1996, 1997 Arizona Board of Regents;
//  see COPYRIGHT file for details.



package toba;

import java.io.*;



public class Field {		// field or method data

    public String name;		// declared name
    public String cname;	        // name used in C
    public String signature;	// signature
    public int access;		// access flags
    public String selfClass;     // name of class containing it (for methods).  

    Attribute attributes[];	// attributes
    Field next;			// link to other methods with same name

    // not set by constructor, but later by Supers.methTable():

    int overrides;		// if >0, overrides ancestor this many levels up
    int mtslot;			// method table slot; -1 if static (or unset)



//  new Field(stream, ctab) -- load field or method info from class file

Field(DataInputStream d, Constant c[])
    throws IOException
{
    access = d.readUnsignedShort();
    mtslot = -1;
    name = (String)c[d.readUnsignedShort()].value;
    signature = (String)c[d.readUnsignedShort()].value;
    attributes = new Attribute[d.readUnsignedShort()];
    for (int i = 0; i < attributes.length; i++)
	attributes[i] = new Attribute(d, c);
}



} // class Field
