//  NativesFile.java -- general procs for writing .c files, excluding method code

//  Copyright 1996, 1997 Arizona Board of Regents;
//  see COPYRIGHT file for details.



package toba;

import java.io.*;
import java.util.*;

class NativesFile {

static private StringBuffer strpool;	// string character pool
static private int strnums[];		// indices of used strings
static private int strlens[];		// lengths of those string
static private int strcount;		// number of used strings



//  write(d, c) -- write header info for class c on stream d.

static void write(PrintWriter d, ClassData c)
{

    // include general definitions
    d.println();
    d.println("#include \"" + c.fname + ".h\"");

    // generate method code
    for (int i = 0; i < c.methods.length; i++) {
	Method m = new Method(c, c.methods[i]);
	if ((m.fl.access & ClassData.ACC_NATIVE) != 0) {
	  try {
	    NativesMethGen.mgen(d, m);
	  } catch (Error e) {
	    Trans.abort("method " + m.fl.name + ": " + e.getMessage());
	  }
	}
    }
}

} // class NativesFile

