#ifndef _FE_MAP_H
#define _FE_MAP_H

// This abstraction maps addresses to fe_managers to fe_managers. This object
// is NOT protected by an internal lock 
// It exposes a lock to be used by the callers

#include "utils/map.h"
#include "utils/address.h"
#include "rwlock.h"

class FE_manager;

class FE_map: public Map<Address, FE_manager*>  {
  public:

    FE_map();
    // effects: Creates an initialized object

    ~FE_map();

    // Methods to lock/unlock this data structure
    void read_lock()    { lock->read_lock();};
    void read_unlock()  { lock->read_unlock();};
    void write_lock()   { lock->write_lock();};
    void write_unlock() { lock->write_unlock();};
  private:
    // Representation
    RW_lock       *lock;      // Lock on entire rep
};

#endif /* _FE_MAP_H */
