#ifndef _FE_RECV_MESSAGE_H
#define _FE_RECV_MESSAGE_H

// This file has all the messages that are received from the FE AND require
// OR-sepcific or FE-specific data strutures to be used. The other messages
// sent by the or/fe are in common/or_message.h common/fe_message.h

#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/intarray.h"
#include "utils/recv_message.h"
#include "common/fe_message.h"
#include "common/transaction.h"

class FE_manager;

class FE_recv_get_root_msg: public Recv_message {
    // Overview: For getting OR root oref
  public:
    Ubits32 type() const {return FE_get_root_type;}
    bool synchronous() const {return FALSE;}
    bool decode(Network* net, Ubits32 msg_id);
};

class FE_recv_fetch_msg: public Recv_message {
  public:
    // Overview: Handler for fetch messages.

    FE_recv_fetch_msg(FE_manager *fe_manager) : mgr(fe_manager) {};
    // Creates a fetch handler for given fe manager.

    Define_message_type(FE_fetch_type);
    Define_asynch_msg();
    bool decode(Network *net, Ubits32 msg_id);

  private:
    FE_manager *mgr;
};



class FE_recv_invalid_ack_msg: public Recv_message {
    // Overview: For receving an invalidation ack at the OR

  public:
    FE_recv_invalid_ack_msg(FE_manager *fe) : mgr(fe) {};

    Define_message_type(FE_invalid_ack_type);
    Define_asynch_msg();
    bool decode(Network *net, Ubits32 msg_id);

  private:
    FE_manager *mgr;
};



class FE_recv_commit_msg: public Recv_message {
    // Overview: Message used to receive FE commit requests
  public:
    FE_recv_commit_msg(FE_manager *fe) : mgr(fe) {};

    Define_message_type(FE_commit_type);
    Define_asynch_msg();
    bool decode(Network *net, Ubits32 msg_id);

  private:
    Ubits32 is_coord;   // If prepare request is for coordinator or participant
    Transaction trans; // The transaction object sent to this OR
    FE_manager *mgr;
};



class FE_recv_alloc_msg: public Recv_message {
    // Overview: For receiving an FE allocation right request
  public:
    FE_recv_alloc_msg(FE_manager *fe) : mgr(fe) {};

    Define_message_type(FE_alloc_type);
    Define_asynch_msg();
    bool decode(Network *net, Ubits32 msg_id);

  private:
    FE_manager *mgr;
};

class FE_recv_debug_msg: public Recv_message {
    // Overview: For receiving an FE allocation right request
  public:
    FE_recv_debug_msg(FE_manager *fe): mgr(fe) {};

    Define_message_type(FE_debug_type);
    Define_asynch_msg();
    bool decode(Network *net, Ubits32 msg_id);

  private:
    FE_manager *mgr;
    Ubits32 debug_type;
    IntArray data;
};

class FE_recv_trigger_msg: public Recv_message {
    // Overview: Generic message from FE to trigger one of several 
    // activities at the OR. The activity is identified by an integer code.
public:
    FE_recv_trigger_msg () {}
    bool decode(Network* net, Ubits32);
    Define_message_type(FE_trigger_type);
    Define_asynch_msg();
private:
    Ubits32 code; // identifies the activity to trigger
};

#endif /* _FE_RECV_MESSAGE_H */
