#include "allocator.h"
#include "gc.h"
#include "gc_transaction.h"
#include "common/or_obj.h"
#include "common/page.h"
#include "or/or.h"
#include "or/mm/mm.h"

Allocator::Allocator(Oref class_oref_, int size_)
    :class_oref(class_oref_), 
     size(size_) 
{
    // Find max number of objs that fit in a page.
    Page p;
    for (objs_per_page = 0;  objs_per_page < Page_slots/size; objs_per_page++)
	if (!p.allocate(objs_per_page, size)) break;

    free_onum = objs_per_page;
    free_page = Max_pages_in_seg;
}

OR_obj *Allocator::alloc(Oref &oref) {
    // Allocate an oref.
    bool new_oref = TRUE;
    if (free_orefs.size() > 0) {
	oref = free_orefs.remove();
	new_oref = FALSE;
    } else {
	if (free_onum >= objs_per_page) {
	    free_page++;
	    free_onum = 0;
	}
	if (free_page >= Max_pages_in_seg) {
	    free_seg = orx->mm->alloc_new_segment();
	    free_page = 0;
	}
	oref = Oref_seg_page_create(free_seg, free_page, free_onum);
	free_onum++;
    }

    OR_obj *obj = OR_obj::create(size);
    obj->set_class_oref(class_oref);
    if (new_oref) 
	gc->transaction->new_obj(oref, obj);
    else  
	gc->transaction->mod_obj(oref, obj);
    return obj;
}

OR_obj *Allocator::copy(OR_obj *obj, Oref oref) {
    OR_obj *obj2 = OR_obj::create(size);
    obj2->set_class_oref(class_oref);
    gc->transaction->mod_obj(oref, obj2);
    
    OR_slot *fields = obj->fields();
    OR_slot *fields2 = obj2->fields();
    memcpy(fields2, fields, size*sizeof(OR_slot));

    return obj2;
}

OR_obj *Allocator::mod(Oref oref) {
    OR_obj *obj2 = OR_obj::create(size);
    obj2->set_class_oref(class_oref);
    gc->transaction->mod_obj(oref, obj2);
    return obj2;
}

void Allocator::free(Oref oref) {
    free_orefs.append(oref);
}
