#include <stdlib.h>
#include <fstream.h>

// #include "fe/boot/wk_xref.h"
#include "fe/boot/fe_wk_xref.h"

#include "partition.h"
#include "mod_list.h"
#include "class_map.h"
#include "collector.h"
#include "translists.h"
#include "deltalists.h"
#include "inoutlists.h"
#include "gc_transaction.h"
#include "gc.h"

GC *gc;
Timer gc_timer, stopped_timer;

GC::GC() {
    gc = this;
    set_parameters();
  
    // initialize shared structures
    partition_map = new Partition_map;
    mod_list = new Mod_list();
    collector = new Collector();
    class_map = new Class_map();
  
    translists = new Translists();
    inoutlists = new Inoutlists();
    deltalists = new Deltalists();
    transaction = new GC_transaction();
  
    // populate the class map
    FILE *fptr;
    char *builtins_filename = getenv("THOR_GC_BUILTINS"),
	*extras_filename = getenv("THOR_GC_EXTRAS");
    fptr = fopen(builtins_filename, "r");
    if (!fptr)
	cout << "GC: Warning: can't open THOR_GC_BUILTINS=" <<
	    builtins_filename << endl;
    else {
	Oref oref;
	int objsize;
	Obj_bitfield ref_bits;
	char name[255];
	int res = fscanf(fptr, "%s %d %d %d\n", name, &oref, 
			 &objsize, &ref_bits);
	cout << "GC: Adding builtin class information." << endl;
	while (res != EOF && fptr != NULL) {
	    class_map->store(name, oref, objsize, ref_bits);
	    res = fscanf(fptr, "%s %d %d %d\n", name, &oref, 
			 &objsize, &ref_bits);
	}
	fclose(fptr);
    }
    fptr = fopen(extras_filename, "r");
    if (fptr == NULL)
	cout << "GC: Warning: can't open THOR_GC_EXTRAS=" <<
	    extras_filename << endl;
    else { // fptr != NULL
	Oref oref;
	int objsize;
	Obj_bitfield ref_bits;
	char name[255];
	int res = fscanf(fptr, "%s %d %d %d\n", name, &oref, 
			 &objsize, &ref_bits);
	cout << "GC: Adding extra class information." << endl;
	while (res != EOF && fptr != NULL) {
	    class_map->store(name, oref, objsize, ref_bits);
	    res = fscanf(fptr, "%s %d %d %d\n", name, &oref, 
			 &objsize, &ref_bits);
	}
	fclose(fptr);
    }
    class_map->store("GCtranslist", WK_GCtranslist_OREF, 
		     gc->translist_block_size, OBJ_BF_INOUTLIST);
    class_map->store("GCinoutlist", WK_GCinoutlist_OREF, 
		     gc->inoutlist_block_size, OBJ_BF_TRANSLIST);
//      class_map->store("GCpmap", WK_GCpmap_OREF,
//  		     gc->pmap_block_size, OBJ_BF_PMAP);
}

void GC::set_parameters() {
    // default parameters

    translist_block_size = 16-2; // ~64 bytes
    inoutlist_block_size = 16-2; // ~64 bytes
    pmap_block_size = 16-2; // ~64 bytes

    segments_per_partition = 32;
    deltalists_size_hi = int(1 * 1024 * 1024);
    float deltalists_low_fraction = 0.75;
    deltalists_size_low = int(deltalists_size_hi * deltalists_low_fraction);
    merge_delta_together = true;
    evict_translist_cache = false;
    mod_list_size_hi = 10 * 1000;
    mod_list_size_low = mod_list_size_hi/4;

    // read parameters from file $THOR_GC, if present
    char *params_filename = getenv("THOR_GC");
    if (params_filename == 0) return;

  // (ifstream >> char*) does not work with g++.
    FILE *params_file = fopen(params_filename, "r"); 
    if (params_file == NULL) {
	cerr << "GC params file not accessible: " << params_filename << endl;
	return;
    }
  
    int const length = 128;
    char line[length];
    while (fgets(line, length, params_file) != NULL) {
	char option[length];
	float value;
	if (sscanf(line, "%s %f", option, &value) != 2) {
	    cerr << "GC params file contains an illegal line" << endl;
	    continue;
	}
	if (0 == strcmp(option, "segments_per_partition"))
	    segments_per_partition = (int)value;
	else if (0 == strcmp(option, "translist_block_size"))
	    translist_block_size = (int)value;
	else if (0 == strcmp(option, "inoutlist_block_size"))
	    inoutlist_block_size = (int)value;
	else if (0 == strcmp(option, "deltalists_size_hi"))
	    deltalists_size_hi = (int)value;
	else if (0 == strcmp(option, "deltalists_low_fraction"))
	    deltalists_low_fraction = value;
	else if (0 == strcmp(option, "mod_list_size_hi"))
	    mod_list_size_hi = (int)value;
	else if (0 == strcmp(option, "merge_delta_together"))
	    merge_delta_together = (int)value;
	else if (0 == strcmp(option, "evict_translist_cache"))
	    evict_translist_cache = (int)value;
	else 
	    cerr << "Unrecognized GC param: " << option << endl;
    }

    mod_list_size_low = mod_list_size_hi/4;
    deltalists_size_low = int(deltalists_size_hi * deltalists_low_fraction);
}

GC::~GC() {
    delete partition_map;
    delete mod_list;
    delete class_map;
    delete collector;

    delete translists;
    delete inoutlists;
    delete deltalists;
    delete transaction;
}

void GC::start_stats() {
    collector->st.start();
    translists->st.start();
    inoutlists->st.start();
    deltalists->st.start();
    transaction->st.start();
}

void GC::print_stats(ostream *out) {
    *out << "GC: statistics start" << endl;
    collector->st.print(out);
    translists->st.print(out);
    inoutlists->st.print(out);
    deltalists->st.print(out);
    transaction->st.print(out);
    *out << "GC: statistics end" << endl;
}

