#ifndef _GC_H
#define _GC_H

// GC contains the external interface for GC at OR.
// It also contains some configuration parameters.

#include "utils/Timer.h"
#include "common/oref.h"
class Partition_map;
class Mod_list;
class Collector;
class Class_map;
class Mutex;
class Condition;

class Deltalists; 
class Translists; 
class Inoutlists; 
class GC_transaction;

class Basic_lists; 
class Potential_lists;
class Delta_lists; 
class GC_objs; 

class ostream;

class GC {
  public:
    GC();
    ~GC();

    void start_stats();
    // start collecting statistics

    void print_stats(ostream *out);
    // prints various statistics to "out"

    // shared data structures
    Partition_map *partition_map; // maps segments to partitions
    Mod_list *mod_list; // modified objs to be scanned
    Collector *collector; // the GC thread
    Class_map *class_map; // maps class orefs to size and reference-bitfields
    Translists *translists; // objects storing interpartition refs 
    Inoutlists *inoutlists; // inlists and outlists
    Deltalists *deltalists; // recent updates to translists
    GC_transaction *transaction; // modified and new objects

    // configuration parameters
    int translist_block_size; // slots in each translist block
    int inoutlist_block_size; // slots in each in/outlist block
    int pmap_block_size; // slots in each partition map block
    int segments_per_partition; // number of segments per partition
    int deltalists_size_hi;  // max size for delta lists
    int deltalists_size_low; // size that delta lists are shrunk to
    int mod_list_size_hi;  // max size for mod_list
    int mod_list_size_low; // size that mod_list is shrunk to
    bool merge_delta_together; // whether to merge delta lists with same target
    bool evict_translist_cache; // evict cache after use; for experimentation
    
#if TRACE_PARTITION
    int partition_low;    // lowest partition number to GC
    int partition_hi;     // highest partition number to GC
    int pause;            // pause between partition traces
#endif
private:
    void set_parameters();
    // Set the parameters to default values.
    // If file $THOR_GC exists, set parameters to values specified there.
};

extern GC *gc;
extern Timer gc_timer, stopped_timer; // for measuring performance

#endif /* _GC_H */
