#ifndef _MOD_LIST_H
#define _MOD_LIST_H

// "Mod_list" contains references to objects modified by the mutator.
// Objects are inserted by the mutator and removed by the collector.

#include <stdio.h>
#include "or/or.h"
#include "or/thread.h"
#include "or/mm/itable.h"
#include "or/mm/mm.h"

class Mod_list {
public:
    Mod_list() {
	mutex = new Mutex();
	condition = new Condition(mutex);
	mods = new Itable_Mods;
    }
    ~Mod_list() {
	delete mutex; 
	delete condition; 
	delete mods;
    }

    int size() const {return mods->size();}
    // Requires caller has locked "mutex".
    // Returns number of entries in list.

    void insert(Itable_Mod *mod) {mods->append(mod); mod->ref();}
    // Requires caller has locked "mutex" and "or->mm->mutex".
    // Inserts mod into "this".

    Itable_Mod* remove() {return mods->remove();}
    // Requires caller has locked "mutex" and this list is not empty.
    // Returns a mod from this.
    // The mod must be "unref"ed by the user when its use is over.

    Itable_Mods* extract(Itable_Mods *new_mods) 
    {Itable_Mods *result = mods; mods = new_mods; return result;}
    // Requires caller has locked "mutex".
    // Returns the current list of mods. 
    // Uses "new_mods" to store further entries.

    Mutex* mutex;
    Condition* condition; 
    // To wait for mods. Waiter should have locked "mutex".
private:
    Itable_Mods *mods;
};


#endif /* _MOD_LIST_H */
