#include "partition.h"

implementArray(Partition_infos, Partition_info);
implementArray(Partitions, Partition_attrib);

Partition_map::Partition_map(): partition_infos(1024), partitions(32) {
    mutex = new Mutex();
//    allocator = new Allocator(WK_GCpmap_OREF, gc->pmap_block_size);
}

Partition_map::~Partition_map() {
    delete mutex;
//    delete allocator;
}

void Partition_map::add_segment(Uint segid) {
    // Currently, just add it to the last partition with space.
    mutex->grab();
    int last_part = partitions.size()-1;
    if (last_part == -1 
	|| partitions[last_part].segs.size() == gc->segments_per_partition) {
	struct Partition_attrib p = {
	    UintArray(gc->segments_per_partition),
	    0};
	partitions.append(p);
	delta_insets.append(0);
	last_part++;
    }
    partitions[last_part].segs.append(segid);
    int rank = partitions[last_part].segs.size() - 1;

    if (segid >= (Uint)partition_infos.size()) {
	Partition_info pi = {0, 0};
	partition_infos.append(pi, segid - partition_infos.size() + 1);
    }
    partition_infos[segid].pid = last_part;
    partition_infos[segid].rank = rank;
    mutex->release();
}

Uint Partition_map::max_partition() {
    mutex->grab();
    Uint res = partitions.size()-1;
    mutex->release();
    return res;
}

void Partition_map::update_inset_change(Uint partition, int delta) {
    mutex->grab();
    printf(">>> Partition_map::update_inset_change: partition=%d, delta=%d\n",
	   partition, delta); //DEBUG
    delta_insets[partition] = delta_insets[partition] + delta;
    mutex->release();
}

void Partition_map::reset_inset_change(Uint partition) {
    mutex->grab();
    printf(">>> Partition_map_::reset_inset_change: partition=%d\n",
	   partition); //DEBUG
    delta_insets[partition] = 0;
    mutex->release();
}

//  Uint Partition_map::least_inset_change() {
//      Uint min_index = 0;
//      int min_delta_inset = 0x7FFFFFFF;
//      printf("Partition_map::least_inset_change: delta_insets.size()=%d\n",
//  	   delta_insets.size()); //DEBUG
//      for (Uint i = 0; i < delta_insets.size(); i++) {
//  	printf("delta_insets[%d]=%d, min_delta_inset=%d\n", //DEBUG
//  	       i, delta_insets[i], min_delta_inset); //DEBUG
//  	if (delta_insets[i] < min_delta_inset) {
//  	    min_index = i;
//  	    min_delta_inset = delta_insets[i];
//  	}
//      }
//      return min_index;
//  }

int Partition_map::inset_change(Uint partition) {
    mutex->grab();
    int res = delta_insets[partition];
    mutex->release();
    return res;
}

int Partition_map::commonality_index(Uint partition, IntSet& others) {
    mutex->grab();
    UintArray segids = partitions[partition].segs;
    int res = 0;
    for (int j = 0; j < segids.size(); j++)
	if (others.contains(segids[j]))
	    res++;
    mutex->release();
    return res;
}

Uint Partition_map::remove_segments(Uint partition, IntSet& segments) {
    mutex->grab();
    Uint res = 0;
    for (int i = 0; i < partitions[partition].segs.size(); i++)
	// for each segid in partition "partition" try to remove from
	// "segments".
	if (segments.remove((partitions[partition].segs)[i])) {
	    printf("removed %d\n", i); //DEBUG
	    res++;
	} else
	    printf("kept %d\n", i); //DEBUG
    mutex->release();
    return res;
}
