#include <iostream.h>
#include "translists.h"
#include "gc.h"
#include "deltalists.h"
#include "inoutlists.h"
#include "gc_transaction.h"
#include "allocator.h"

#include "utils/fail.h"
#include "common/or_obj.h"
#include "common/page.h"
// #include "common/wk_xref.h"
#include "fe/boot/fe_wk_xref.h"

#include "or/or.h"
#include "or/mm/mm.h"
#include "or/mm/handle.h"

// A translist is a linked list of blocks.
// Each block contains orefs. NULL_OREF terminates the list.
// All remaining orefs in the block are null. (superfluous!)
// The last oref in a block gives the oref for the next block.

Translists::Translists() {
    allocator = new Allocator(WK_GCtranslist_OREF, gc->translist_block_size);
}

int Translists::merge_delta(Uint source_p, Uint target_p, 
			    Deltalist *delta, 
			    bool replace) {
    printf(">>> merge_delta source_p=%u, target_p=%u, replace=%d\n", //DEBUG
	   source_p, target_p, replace); //DEBUG
    Oref translist_oref = gc->inoutlists->get_translist(source_p, target_p);
    if (replace) { // empty translist before merging deltalist
	free_translist(translist_oref);
	translist_oref = NULL_OREF;
    }

    // Remove existing translist entries from deltalist.
    const int block_size = gc->translist_block_size;
    OR_obj *block = 0;
    OR_slot *fields = 0;
    MM_Handle *handle = 0;
    int i = block_size - 1, size_change = 0;
    Oref block_oref = translist_oref; // oref for current block
    Oref oref = translist_oref; // an oref contained in the block
    bool existed = (oref != NULL_OREF);
    while (oref != NULL_OREF) {
	if (i == block_size - 1) { // last oref in the block
	    if (handle) 
		orx->mm->release(handle); // release previous block
	    block_oref = oref;
	    handle = orx->mm->fetch(block_oref);
	    if (handle == 0) 
		fail("Translist-block not fetched: %d", oref);
	    st.fetches++;
	    if (handle->fetched_from_disk()) 
		st.disk_fetches++;
            else if (handle->fetched_from_itable()) 
		st.mob_fetches++;
	    block = handle->obj();
	    fields = block->fields();
	    i = 0;
	} else {
	    printf("removing %d from deltalist\n", oref); //DEBUG
	    delta->remove(oref);
	    i++;
	    size_change++;
	}
	oref = fields[i].get_oref();
    }
    th_assert((((oref == 0) && (i == block_size - 1)) ||
	       (fields[i].uvalue32 == 0)), "before adding deltalist entries");
    // Add remaining deltalist entries into translist.
    int size = delta->size();
    size_change -= size;
    IntSet::Elements delta_gen(delta);
    int elem;
    // First fill the last block.
    if (existed && size > 0) {
	block = allocator->copy(block, block_oref); // adds to gc->transaction
	fields = block->fields();
	orx->mm->release(handle);
	for (; i < block_size - 1; i++) {
	    if (!delta_gen.get(elem)) 
		break;
	    printf("setting last translist block at %d of %d to oref=%d\n",
		   i, block_size - 1, elem); //DEBUG
	    fields[i].set_oref(elem);
	    size--; // deltalist size
	}
    }
    bool first_new_block = TRUE;
    // Now fill new blocks.
    while (size > 0) { // while deltalist size is positive
	th_assert(i == block_size - 1, "correct i value"); //DEBUG
	block = allocator->alloc(block_oref); // adds to gc->transaction
	printf("Allocated new oref %d for new block\n", block_oref); //DEBUG
	block->set_class_oref(WK_GCtranslist_OREF);
	st.blocks++;
	if (!existed) {
	    if (!first_new_block) {
		printf("setting (previous) translist block at \
%d of %d to oref=%d\n", i, block_size - 1, block_oref); //DEBUG
		fields[i].set_oref(block_oref);
	    } else {
		translist_oref = block_oref;
		first_new_block = FALSE;
	    }
	} else { // existed
	    printf("setting (previous) translist block at \
%d of %d to oref=%d\n", i, block_size - 1, block_oref); //DEBUG
	    fields[i].set_oref(block_oref); // seg fault here????
	}
	fields = block->fields();
	for (i = 0; i < block_size - 1; i++) {
	    if (!delta_gen.get(elem)) 
		break;
	    printf("setting translist block at %d of %d to oref=%d\n", //DEBUG
		   i, block_size - 1, elem); //DEBUG
	    fields[i].set_oref(elem);
	    size--; // deltalist size
	}
	// Set remaining orefs in block NULL.
	for (int j = i; j < block_size; j++) {
	    printf("nullifying translist block at %d of %d\n", //DEBUG
		   j, block_size - 1); //DEBUG
	    fields[j].set_oref(NULL_OREF);
	}
    } // while (size > 0)
    th_assert(delta->size() == 0, "deltalist size"); //DEBUG
//      printf("committing gc_transaction\n"); //DEBUG
//      gc->transaction->commit(); // XXXXX may be better way; is it necessary????
    bool exists = (translist_oref != NULL_OREF);
    if (! existed && exists) {
	st.num_translists++;
	printf("translist oref=%d -> in+outlists between %d and %d\n", //DEBUG
	       translist_oref, source_p, target_p); //DEBUG
	gc->inoutlists->add_translist(source_p, target_p, translist_oref);
    } else if (existed && ! exists) {
	gc->inoutlists->remove_translist(source_p, target_p);
    }
    printf("<<< merge_delta\n"); //DEBUG
    return size_change;
}

Translists::Stats::Stats(){
    blocks = 0;
    num_translists = 0;
}

void Translists::Stats::start() {}

void Translists::Stats::print(ostream *out) {
    *out << "Translists created:" << num_translists << endl;
    *out << "Translists byte usage: "
	 << blocks*gc->translist_block_size*sizeof(Slot) << endl;
    *out << "Translist block fetches:" << fetches << endl;
    *out << "Translist block fetches from mob: " << mob_fetches << endl;
    *out << "Translist block fetches from disk: " << disk_fetches << endl;
}

Translists::Elements::Elements(Oref translist_oref) {
    i = 0;
    handle = orx->mm->fetch(translist_oref);
    if (handle == 0) fail("Translist-block not fetched: %d", translist_oref);
    fields = handle->obj()->fields();
}

Oref Translists::Elements::get() {
    if (i == gc->translist_block_size-1) {
	release();
	Oref last_oref = fields[i].get_oref();
	if (last_oref == NULL_OREF) return NULL_OREF;
	handle = orx->mm->fetch(last_oref);
	if (handle == 0) fail("Inlist-block not fetched: %d", last_oref);
	fields = handle->obj()->fields();
	i = 0;
    }
    Oref oref = fields[i++].get_oref();
    if (oref == NULL_OREF) release();
    return oref;
}

void Translists::Elements::release() {
	if (handle) orx->mm->release(handle);
	handle = 0;
}

void Translists::free_translist(Oref translist_oref)
{
    Orefs block_orefs;
    while (translist_oref != NULL_OREF) {
	block_orefs.append(translist_oref);
	MM_Handle *handle = orx->mm->fetch(translist_oref);
	if (handle == 0) fail("Tlist-block not fetched: %d", translist_oref);
	OR_slot* fields = handle->obj()->fields();
	translist_oref = fields[gc->translist_block_size-1].get_oref();
	orx->mm->release(handle);
    }
    while (block_orefs.size() > 0)
	allocator->free(block_orefs.remove());
}


