// Copyright 1995 Barbara Liskov

// \section{OR initialization code}

#include <fcntl.h>
#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>

#include "utils/fail.h"
#include "utils/th_assert.h"
#include "utils/hostname.h"
#include "common/locator.h"

#include "mm/log.h"
#include "mm/mm.h"
#include "gc/gc.h"
#include "gc/collector.h"
#include "init.h"
#include "or.h"
#include "or_config.h"
#include "or_manager.h"
#include "tm.h"
#include "fe_map.h"
#include "tstatus.h"
#include "cachedir.h"

OR* orx = 0;

static void init_locator(void);

void OR_common_init(bool new_db) {
    // Initialization that is needed at recovery or new database creation
    // new_db indicates whether a new database is being created

    // Initialize various components of the OR

    // Must find our OR number before creating other components
    init_locator();
    orx->or_managers = new OR_manager_set();
    orx->log = new Log();         // Log must be initialized before TM.
    orx->cachedir = new CacheDir; // Must be initialized before MM
    orx->mm = new MM(new_db);
    orx->tm = new TM;
    orx->tstatus = new Transaction_Status();
    orx->fe_map = new FE_map;
    if (gc) {
      gc->collector->init();
      gc->collector->start(TH_MIN_PRIO);
      gc->start_stats();
    }
}

void OR_init() {
//  #ifdef __linux__
//      pth_init();
//  #endif
    OR_common_init(TRUE);
}

void OR_recover() {
    OR_common_init(FALSE);
}

static void init_locator(void)
{
    orx->locator = new Locator;

    Address addr = OR_address(orx->config->ornum);
    Ubits32 host_id; int port;
    if (!orx->locator->lookup(addr, &host_id, &port))
	fail("or: could not find address in locator");

    // check if host_id matches that of current machine
    // Get my host name
    char hostname[MAXHOSTNAMELEN+1];
    if (gethostname(hostname, MAXHOSTNAMELEN+1) < 0)
	sysfail("or: could not find local host name");
    // Get my host address
    struct in_addr inaddr;
    if (!findhost(hostname, &inaddr))
	fail("or: could not find local IP address");
    if (inaddr.s_addr != host_id)
	fail("or: current host does not match info from locator");
    
    int port_offset = port - OR_DEFAULT_FE_PORT;
    orx->config->fe_socket   = port;
    orx->config->or_socket   = OR_DEFAULT_OR_PORT + port_offset;
}
