# Copyright 1995 Barbara Liskov

# Tcl procedures for help in building an OR database.

# effects - Create object in seg with slots initialized from list.
#	    Returns the oref for the object
proc object {seg class list} {
    set desc ""
    foreach x $list {
	if {[llength $x] == 2} {
	    # Oref
	    lappend desc ref
	    continue
	}

	# Must be integer?
	lappend desc data
    }

    set obj [new $seg $class $desc]

    set i 0
    foreach x $list {
	store $obj $i $x
    }

    return $obj
}

# effects - create new list in seg. Arguments should be orefs.
proc thorlist {seg args} {
  if {[llength $args] > 0} {
    set head [new $seg fulllist {ref ref}]
    set current $head
    foreach x $args {
      store $current 0 $x
      set next [new $seg fulllist {ref ref}]
      store $current 1 $next
      set last $current
      set current $next
    }
    store $last 1 [new $seg emptylist {alldata 1}]
    return $head
  } else {
    return [new $seg emptylist {alldata 1}]
  }
}

# effects - create new integer list in seg. Arguments should be ints.
proc intlist {seg args} {
  if {[llength $args] > 0} {
    set head [new $seg fullintlist {data ref}]
    set current $head
    foreach x $args {
      store $current 0 $x
      set next [new $seg fullintlist {data ref}]
      store $current 1 $next
      set last $current
      set current $next
    }
    store $last 1 [new $seg emptyintlist {alldata 1}]
    return $head
  } 
  else {
    return [new $seg emptyintlist {alldata 1}]
  }
}

# effects - cons a new cell onto list.  Arguments should be orefs.
proc thorcons {seg obj rest} {
  set newcons [new $seg fulllist {ref ref}]
  store $newcons 0 $obj
  store $newcons 1 $rest
  return $newcons
}

# effects - return an empty list
proc thornil {seg} {
  return [new $seg emptylist {alldata 1}]
}

# effects - create an intany containing the argument in the segment
proc intcell {seg val} {
  set cell [new $seg intany {alldata 1}]
  store $cell 0 $val
  return $cell
}
