# Copyright 1995 Barbara Liskov

puts stdout "======"
puts stdout "This script checks that the OR database generation"
puts stdout "code packs values together correctly.  There should be"
puts stdout "no more output."
puts stdout "======"

set s [segment]
set x [new $s string {alldata 1}]
root $x

proc check_error {msg args} {
    global x

    if [catch {store $x 0 $args} result] {
	if {$msg != $result} {
	    puts stdout ">>wrong error: $result <[join $args]>"
	}
    } else {
	puts stderr "accepted invalid packing <[join $args]>"
    }
}

proc check_ok {args} {
    global x

    if [catch {store $x 0 $args} result] {
	puts stdout ">>error: $result <[join $args]>"
    }
}

# Length error
check_error "odd count in packing" 1 2 3

# Homogenous packing
check_ok long 0xf0f0f0f0f0f0f0f0
check_ok int 1
check_ok int 1 int 2
check_ok short 1
check_ok short 1 short 2
check_ok short 1 short 2 short 3
check_ok short 1 short 2 short 3 short 4
check_ok bool 1
check_ok bool 1 bool 0
check_ok bool 1 bool 0 bool 1
check_ok bool 1 bool 0 bool 1 bool 0
check_ok bool 1 bool 0 bool 1 bool 0 bool 1
check_ok bool 1 bool 0 bool 1 bool 0 bool 1 bool 0
check_ok bool 1 bool 0 bool 1 bool 0 bool 1 bool 0 bool 1
check_ok bool 1 bool 0 bool 1 bool 0 bool 1 bool 0 bool 1 bool 0
check_ok byte 1
check_ok byte 1 byte 2
check_ok byte 1 byte 2 byte 3
check_ok byte 1 byte 2 byte 3 byte 4
check_ok byte 1 byte 2 byte 3 byte 4 byte 5
check_ok byte 1 byte 2 byte 3 byte 4 byte 5 byte 6
check_ok byte 1 byte 2 byte 3 byte 4 byte 5 byte 6 byte 7
check_ok byte 1 byte 2 byte 3 byte 4 byte 5 byte 6 byte 7 byte 8
check_ok char ""
check_ok char "a"
check_ok char "ab"
check_ok char "abc"
check_ok char "abcd"
check_ok char "abcde"
check_ok char "abcdef"
check_ok char "abcdefg"
check_ok char "abcdefgh"

# Heterogenous packing
check_ok long 1 char ""
check_ok int 1 short 2 short 3
check_ok char "a" byte 2 short 3 int 4
check_ok bool 0 char "abc" int 3

# Data type errors
check_error "invalid integer in packing"	int x
check_error "invalid long in packing"		long x
check_error "invalid short in packing"		short x
check_error "invalid byte in packing"		byte x
check_error "invalid boolean in packing"	bool 10

# Size errors
check_error "too much data in packing" long 0 int 1
check_error "too much data in packing" long 0 long 1
check_error "too much data in packing" long 0 short 1
check_error "too much data in packing" long 0 bool 1
check_error "too much data in packing" long 0 byte 1
check_error "too much data in packing" long 0 char "a"

# Alignment errors
check_error "invalid alignment in packing" byte 1 int 2
check_error "invalid alignment in packing" short 1 int 2
check_error "invalid alignment in packing" byte 1 short 2
