#ifndef _BACK_SEND_MESSAGE_H
#define _BACK_SEND_MESSAGE_H

#include "utils/basic.h"
#include "utils/intarray.h"
#include "utils/send_message.h"
#include "common/fe_message.h"


class Log_Record;
class Network;

#define Back_send_ack_type 301
#define Back_send_shutack_type 303

class Back_send_ack_msg: public Send_message {
    // Overview: For getting OR root oref
  public:
    Back_send_ack_msg(Ubits32 num)
      : noofrecords(num){};
    bool encode(Network* net);
    Define_message_type(Back_send_ack_type);

  private:
     Ubits32      noofrecords;
};

class Back_send_shutack_msg: public Send_message {
    // Overview: For getting OR root oref
  public:
    Back_send_shutack_msg(Ubits32 num)
      : shutdown_value(num){};
    bool encode(Network* net);
    Define_message_type(Back_send_shutack_type);

  private:
     Ubits32      shutdown_value;
};

#endif /* _BACK_SEND_MESSAGE_H */





