
/* sigevent defintions */

#ifndef _LINUX_SIGEVENT_H_
#define _LINUX_SIGEVENT_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <pthread.h>
#ifdef __linux__
#include <signal.h>
#endif

#ifndef __linux__
typedef union sigval {
        int     sival_int;
        void    *sival_ptr;
} sigval_t;

#define SIGEV_SIGNAL (0)        /* Notify via signal */
#define SIGEV_NONE   (1)        /* Other notification: unsupported */
#define SIGEV_THREAD (2)        /* Deliver via thread creation */    
#endif /* __linux__ */
#define SIGEV_MAX_SIZE  (64)
#define SIGEV_PAD_SIZE ((SIGEV_MAX_SIZE/sizeof(int)) - 4)

typedef struct sigevent_event {
#ifndef __linux__
        sigval_t        _sigev_value;   /* application-defined value */
#endif
        int             _sigev_signo;   /* signal to raise */
        int             _sigev_notify;  /* raise a signal? */
} sigevent_event_t;

#ifndef __linux__
typedef struct sigevent {
  sigevent_event_t        _sigev_sigevent;
  union {
    int             _sigev[SIGEV_PAD_SIZE];
    void            (*_sigev_notify_function) (sigval_t);
    pthread_attr_t  *_sigev_notify_attribute;
  } _sigev_un;
} sigevent_t;
#endif /* __linux__ */

/*
 * Sigevent struct access macros.
 */
#ifndef __linux__
#define sigev_value     _sigev_sigevent._sigev_value
#define sigev_signo     _sigev_sigevent._sigev_signo
#define sigev_notify    _sigev_sigevent._sigev_notify
#endif
#define sigev_notify_function   _sigev_un._sigev_notify_function
#define sigev_notify_attributes _sigev_un._sigev_notify_attribute



#ifdef __cplusplus
}
#endif
#endif 
