#ifndef _PRIM_SEND_MESSAGE_H
#define _PRIM_SEND_MESSAGE_H

#include "utils/basic.h"
#include "utils/intarray.h"
#include "utils/send_message.h"
#include "common/fe_message.h"
#include "common/oref.h"

#include "or/mm/logrecord.h"
#include "or/mm/log.h"
#include "or/mm/mm.h"


#define Prim_send_data_type 300
#define Prim_send_shutdown_type 301


class Log_Record;
class Network;
class Log;

class Prim_send_data_msg: public Send_message {
    // Overview: For getting OR root oref
  public:
    Prim_send_data_msg(Log* temp_log, Ubits32 num)
      : mm_log(temp_log), noofrecords(num){}

    bool encode(Network* net);
    Define_message_type(Prim_send_data_type);

    Log* mm_log;
    Ubits32      noofrecords;
};

class Prim_send_shutdown_msg: public Send_message {
  public:
    Prim_send_shutdown_msg(Ubits32 num)
      : shutdown_value(num){}

    bool encode(Network* net);
    Define_message_type(Prim_send_shutdown_type);

    Ubits32      shutdown_value;
};

#endif 


